package Application::Model::Queue::Support::Target::Blocks;

use qbit;
use Utils::PublicID;
use Utils::DB qw(fields_to_filter model_to_prefix);

sub form_name {'blocks'}
sub data_name {'block_list'}

sub field {
    my ($self) = @_;
    return +{
        name  => $self->form_name,
        label => gettext('Block IDs'),
        type  => 'textarea',
        trim  => TRUE,
    };
}

sub check {
    my ($self, $app, $data) = @_;

    my @blocks = map scalar(split_block_public_id($_, 1)), split(/\s*[,\n]\s*/, $data->{$self->form_name});

    my $sql = $app->partner_db->query->select(
        table  => $app->partner_db->all_blocks,
        fields => {
            block_model => 'model',
            page_id     => '',
            block_id    => 'id',
            multistate  => '',
            # is_custom_bk_data => '',
            public_id => {concat => [model_to_prefix($app, 'model'), 'page_id', \'-', 'id']},
        },
        filter => [
            AND =>
              [fields_to_filter(['page_id', 'id'], \@blocks, for_db => TRUE), @{$data->{filter}{filter_all_blocks}}]
        ],
      )->join(
        table  => $app->partner_db->all_pages,
        fields => {
            page_model      => 'model',
            login           => '',
            page_multistate => 'multistate',
        },
        join_on => [page_id => '=' => {page_id => $app->partner_db->all_blocks}],
        filter => [AND => [\1, @{$data->{filter}{filter_all_pages}}]]
      );

    for my $jp (@{$data->{filter}{join_all_blocks}}) {
        $sql = $sql->left_join(%$jp);
    }

    my $list = $sql->get_all;

    my %has = map {$_->{public_id} => $_} @$list;
    my @fail = grep {!$has{$_}} map {$_->{public_id}} @blocks;
    if (@fail) {
        return join(', ', @fail);
    }

    my @result = values %has;
    $data->{$self->data_name} = \@result;

    return ('', scalar @result);
}

sub get_pages {
    my ($self, $app, $data) = @_;

    my %pages = map {
        $_->{page_id} => {
            login      => $_->{login},
            page_id    => $_->{page_id},
            page_model => $_->{page_model},
            multistate => $_->{page_multistate},
          }
    } @{$data->{$self->data_name}};

    return [values %pages];
}

sub get_blocks {
    my ($self, $app, $data) = @_;

    return $data->{$self->data_name};
}

1;
