package Application::Model::Queue::Support::Target::Logins;

use qbit;
use Utils::DB qw(model_to_prefix);

sub form_name {'logins'}
sub data_name {'login_list'}

sub field {
    my ($self) = @_;

    return +{
        name  => $self->form_name,
        label => gettext('Logins'),
        type  => 'textarea',
        trim  => TRUE,
    };
}

sub check {
    my ($self, $app, $data) = @_;

    my @logins = split /\s*[,\n]\s*/, $data->{$self->form_name};

    my $list = $app->partner_db->users->get_all(
        fields => ["login"],
        filter => [login => 'IN' => \\@logins],
    );

    my %has = map {$_->{login} => TRUE} @$list;
    my @fail = grep {!$has{$_}} @logins;
    if (@fail) {
        return join(', ', @fail);
    }

    my @result = keys %has;
    $data->{$self->data_name} = \@result;

    return ('', scalar @result);
}

sub get_pages {
    my ($self, $app, $data) = @_;

    my $list = $app->partner_db->query->select(
        table  => $app->partner_db->all_pages,
        fields => {
            page_id    => '',
            page_model => 'model',
            login      => '',
            multistate => '',
        },
        filter => [AND => [[login => 'IN' => \$data->{$self->data_name}], @{$data->{filter}{filter_all_pages}}]],
    )->get_all;

    return $list;
}

sub get_blocks {
    my ($self, $app, $data) = @_;

    my $sql = $app->partner_db->query->select(
        table  => $app->partner_db->all_blocks,
        fields => {
            block_model => 'model',
            page_id     => '',
            block_id    => 'id',
            multistate  => '',
            # is_custom_bk_data => '',
            public_id => {concat => [model_to_prefix($app, 'model'), 'page_id', \'-', 'id']},
        },
        filter => [AND => [\1, @{$data->{filter}{filter_all_blocks}}]],
      )->join(
        table  => $app->partner_db->all_pages,
        fields => {
            page_model      => 'model',
            login           => '',
            page_multistate => 'multistate',
        },
        filter => [AND => [[login => 'IN' => \$data->{$self->data_name}], @{$data->{filter}{filter_all_pages}}]],
        join_on => ['page_id' => '=' => {'page_id' => $app->partner_db->all_blocks}]
      );

    for my $jp (@{$data->{filter}{join_all_blocks}}) {
        $sql = $sql->left_join(%$jp);
    }

    my $list = $sql->get_all;

    return $list;
}

1;
