package Application::Model::Queue::Support::Target::Pages;

use qbit;
use Utils::DB qw(model_to_prefix);

sub form_name {'pages'}
sub data_name {'page_list'}

sub field {
    my ($self) = @_;

    return +{
        name  => $self->form_name,
        label => gettext('Page IDs'),
        type  => 'textarea',
        trim  => TRUE,
    };
}

sub check {
    my ($self, $app, $data) = @_;

    my @pages = split /\s*[,\n]\s*/, $data->{$self->form_name};

    my $list = $app->partner_db->all_pages->get_all(
        fields => {
            page_id    => '',
            page_model => 'model',
            login      => '',
            multistate => '',
        },
        filter => [AND => [[page_id => 'IN' => \\@pages], @{$data->{filter}{filter_all_pages}}]],
    );

    my @fail;
    my %has = map {$_->{page_id} => $_} @$list;
    push @fail, grep {!$has{$_}} @pages;
    if (@fail) {
        return join(', ', @fail);
    }

    my @result = values %has;
    $data->{$self->data_name} = \@result;

    return ('', scalar @result);
}

sub get_pages {
    my ($self, $app, $data) = @_;

    return $data->{$self->data_name};
}

sub get_blocks {
    my ($self, $app, $data) = @_;

    my $sql = $app->partner_db->query->select(
        table  => $app->partner_db->all_blocks,
        fields => {
            block_model => 'model',
            page_id     => '',
            block_id    => 'id',
            multistate  => '',
            # is_custom_bk_data => '',
            public_id => {concat => [model_to_prefix($app, 'model'), 'page_id', \'-', 'id']},
        },
        filter => [
            AND => [
                [page_id => 'IN' => \[map {$_->{page_id}} @{$data->{$self->data_name}}]],
                @{$data->{filter}{filter_all_blocks}}
            ]
        ],
    );

    for my $jp (@{$data->{filter}{join_all_blocks}}) {
        $sql = $sql->left_join(%$jp);
    }

    my $list = $sql->get_all;

    return $list;
}

1;
