package Application::Model::Queue::Support::UnmoderatedDSP;

use qbit;
use base qw(Application::Model::Queue::Support::Base);

my $structure = {
    target => [
        qw(
          Application::Model::Queue::Support::Target::Logins
          Application::Model::Queue::Support::Target::Pages
          Application::Model::Queue::Support::Target::Blocks
          )
    ],
    source => [
        qw(
          Application::Model::Queue::Support::Source::UnmoderatedDSP
          Application::Model::Queue::Support::Source::UnmoderatedRtbAuction
          )
    ],
    filter => [
        qw(
          Application::Model::Queue::Support::Filter::SpecialBlock
          Application::Model::Queue::Support::Filter::UnmoderatedRtbAuction
          Application::Model::Queue::Support::Filter::MobileBlockTypeDSP
          )
    ],
};

sub get_structure_data {$structure}

sub method     {'turn_on_unmoderate_dsp'}
sub right_add  {'queue_add_turn_on_unmoderate_dsp'}
sub right_view {'queue_turn_on_unmoderate_dsp'}
sub title      {gettext('Turn on unmoderated DSP')}

sub apply_real_process {
    my ($self, $app, $data) = @_;

    my $pages = $self->get_pages($app, $data);
    my $result_pages =
      Application::Model::Queue::Support::Source::UnmoderatedRtbAuction->apply_to_list($app, $data, $pages);

    my $blocks = $self->get_blocks($app, $data);
    my $result = Application::Model::Queue::Support::Source::UnmoderatedDSP->apply_to_list($app, $data, $blocks);

    my %resend = map {$_ => undef} @{$result->{resend}}, @{$result_pages->{resend}};
    $result->{resend} = [sort keys %resend];
    push @{$result->{errors}}, @{$result_pages->{errors}};
    $result->{modify_by_model} = $result_pages->{modify_by_model};

    return $result;
}

sub get_start_message {gettext("Add task for turn on unmoderated DSP")}
sub get_done_message  {gettext("Finish task for turn on unmoderated DSP")}

1;
