package Application::Model::Role::Block::AdFoxNotifier;

use qbit;

use Application::Model::Role;

consume qw(
  Application::Model::Role::Has::PlaceID
  );

sub on_action_delete {
    my $self = shift();
    $self->_notify_adfox_block_delete(@_);
}

sub on_action_delete_with_page {
    my $self = shift();
    $self->_notify_adfox_block_delete(@_);
}

sub _notify_adfox_block_delete {
    my ($self, $block, %opts) = @_;

    my $fields = $self->get($block, fields => [qw/place_id/]);

    if (defined $fields->{place_id}) {
        $self->app->api_adfox_graphql->delete_block(place_id => $fields->{place_id});

        $self->partner_db_table->edit($block, {place_id => \undef});

    }
}

sub hook_processing_after_update {
    my ($self, $opts) = @_;

    my ($old_caption, $place_id) = @{$self->hook_stash->get('current')}{qw/caption place_id/};
    if (defined $place_id) {
        my $new_caption = $opts->{caption};
        if (defined($new_caption) && $new_caption ne $old_caption) {
            $self->app->api_adfox_graphql->update_block_name(
                place_id => $place_id,
                new_name => $new_caption
            );
        }
    }
}

TRUE;
