package Application::Model::Role::Block::Has::AdfoxBlock;

use qbit;

use Application::Model::Role;

sub check_can_view_adfox_fields {1}

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        adfox_block => {
            db         => TRUE,
            label      => d_gettext('ADFOX block'),
            api        => 1,
            type       => 'boolean',
            need_check => {
                type     => 'boolean',
                optional => TRUE,
            },
            adjust_type => 'str',
        },
    };
}

sub get_structure_model_filter {
    my ($self) = @_;

    return {fields => {adfox_block => {type => 'boolean', label => d_gettext('ADFOX block')},}};
}

sub get_db_filter_simple_fields {
    my ($self) = @_;

    return [{name => 'adfox_block', label => gettext('ADFOX block')}] if $self->check_can_view_adfox_fields();
}

sub get_structure_multistates_graph {
    my ($self) = @_;

    return {
        actions            => {delete_from_adfox => d_pgettext('Block action', 'Archive from ADFOX'),},
        multistate_actions => [
            {
                action    => 'delete_from_adfox',
                from      => 'not deleted',
                set_flags => ['deleted'],
            },
        ],
    };
}

sub get_available_fields_depends {
    [qw(adfox_block)];
}

sub get_available_fields {
    my ($self, $obj, $fields) = @_;

    if ($obj->{'adfox_block'}) {
        delete($fields->{$_}) foreach (
            qw(
            allow_multiple_dsp_ads
            alternative_code
            alt_width
            alt_height
            )
        );

    } else {
        delete($fields->{$_}) foreach qw(
          adfox_block
          );
    }

    return $fields;
}

sub get_add_fields {
    my ($self, $fields, $data) = @_;

    $fields->{'adfox_block'} = TRUE;

    return $fields;
}

sub can_action_delete {
    my ($self, $block) = @_;

    my $fields = $self->_get_object_fields($block, [qw(adfox_block)]);

    return $fields->{'adfox_block'} ? FALSE : TRUE;
}

sub can_action_duplicate {
    my ($self, $block) = @_;

    return TRUE if $self->DOES('Application::Model::Block::Video');
    my $fields = $self->_get_object_fields($block, [qw(adfox_block)]);

    return $fields->{'adfox_block'} ? FALSE : TRUE;
}

sub can_action_delete_from_adfox {
    my ($self, $block) = @_;

    my $fields = $self->_get_object_fields($block, [qw(adfox_block)]);

    return $fields->{'adfox_block'} ? TRUE : FALSE;
}

sub on_action_delete_from_adfox {
    my ($self, $block, %opts) = @_;

    $self->maybe_do_action($block, 'stop');

    $self->update_in_bk($block) unless $opts{'do_not_update_in_bk'};

    $self->change_blocks_count($block, '-');

    return TRUE;
}

sub can_action_restore {
    my ($self, $block) = @_;

    my $fields = $self->_get_object_fields($block, [qw(adfox_block)]);

    return $fields->{'adfox_block'} ? FALSE : TRUE;
}

sub can_action_restore_with_page {
    my ($self, $block) = @_;

    my $fields = $self->_get_object_fields($block, [qw(adfox_block)]);

    return $fields->{'adfox_block'} ? FALSE : TRUE;
}

sub hook_fields_processing_before_validation {
    my ($self, $opts) = @_;

    if ($self->hook_stash->mode('add')) {
        $opts->{'adfox_block'} //= 0;
    }
}

sub get_actions_depends {
    [
        qw(
          adfox_block
          )
    ];
}

sub get_bk_block_data {
    my ($self, $block, $bk_data) = @_;

    $bk_data->{'AdFoxBlock'} = $block->{'adfox_block'};

    return $bk_data;
}

sub get_editable_fields_depends {
    [
        qw(
          adfox_block
          )
    ];
}

TRUE;
