package Application::Model::Role::Block::Has::BlocksLimit;

use qbit;

use Application::Model::Role;

=head
Для внешних и внутренних блоков.
=cut

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        blocks_limit => {
            depends_on => ['page_id', 'pages.blocks_limit'],
            label      => d_gettext('blocks_limit'),
            get        => sub {
                $_[0]->{'pages'}{$_[1]->{'page_id'}}{'blocks_limit'};
            },
            api  => 1,
            type => 'number',
        },
        blocks_count => {
            depends_on => ['page_id', 'pages.blocks_count'],
            label      => d_gettext('blocks_count'),
            get        => sub {
                $_[0]->{'pages'}{$_[1]->{'page_id'}}{'blocks_count'};
            },
            api  => 1,
            type => 'number',
        },
    };
}

sub hook_fields_validation {
    my ($self, $opts) = @_;

    my $page_id_field_name = $self->get_page_id_field_name();

    my $page_data = $self->page->get_all(
        fields => [qw(blocks_limit blocks_count)],
        filter => {page_id => $opts->{'page_id'} // $opts->{$page_id_field_name}},
    );

    if ($page_data->[0]->{'blocks_limit'} <= $page_data->[0]->{'blocks_count'}) {
        throw Exception::Denied gettext('You cannot add another block. Limit exceeded');
    }
}

sub check_action {
    my ($self, $object, $action) = @_;

    my %actions = map {$_ => TRUE} qw(duplicate restore);

    if (exists $actions{$action}) {
        my $obj = $self->_get_object_fields($object, [qw(blocks_limit blocks_count)]);
        if ($obj->{'blocks_limit'} <= $obj->{'blocks_count'}) {
            return FALSE;
        }
    }

    return TRUE;
}

sub hook_processing_after_insert {
    my ($self, $block) = @_;
    #Работает после добавления и восстановления

    $self->change_blocks_count($block, '+');
}

sub on_action_delete {
    my ($self, $block) = @_;

    $self->change_blocks_count($block, '-');
}

sub on_action_restore {
    my ($self, $block) = @_;

    $self->change_blocks_count($block, '+');
}

sub change_blocks_count {
    my ($self, $block, $sign) = @_;

    my $campaign = $self->get_campaign_model_name();
    my $obj = $self->_get_object_fields($block, [qw(page)]);

    $self->partner_db->$campaign->edit($obj->{page}->{id}, {'blocks_count' => [$sign => ['blocks_count', \1]]});
}

sub get_actions_depends {
    [
        qw(
          blocks_limit
          blocks_count
          )
    ];
}

TRUE;
