package Application::Model::Role::Block::Has::CPMCurrency;

use qbit;

use POSIX;
use Application::Model::Role;
use PiConstants qw($DEFAULT_CPM_CURRENCY
  $MIN_CPM_STRATEGY_ID
  $MAX_REVENUE_STRATEGY_ID
  $SEPARATE_CPM_STRATEGY_ID
  $RTB_PRODUCT_TYPES
  $MAX_CPM);

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        current_currency => {
            depends_on => ['page_id', 'pages.owner'],
            label      => d_gettext('current_currency'),
            get        => sub {
                $_[0]->{'pages'}{$_[1]->{'page_id'}}{'owner'}{'current_currency'};
            },
            api  => 1,
            type => 'string',
        },
    };
}

sub get_structure_model_filter {
    my ($self) = @_;

    return {
        fields => {
            current_currency => {
                type => 'alias',
                path => [qw(page owner current_currency)],
            }
        }
    };
}

sub get_bk_block_data {
    my ($self, $block, $data) = @_;

    $data->{'CPMCurrency'} = $block->{'current_currency'} // $DEFAULT_CPM_CURRENCY;

    return $data;
}

sub convert_block_cpm_currency {
    my ($self, $block, $next_currency, $currency_rate) = @_;
    my $patch;
    #стратегия
    my $tmp_all_rights = $self->app->add_all_tmp_rights();
    my @fields         = qw(actions is_custom_bk_data bk_data);
    if ($self->DOES('Application::Model::Role::Has::Strategies')) {

        my $strategies = $self->get_strategies();
        push @fields, 'mincpm' if $strategies->{$MIN_CPM_STRATEGY_ID};
        push @fields, map {$_ . "_cpm"} @{$strategies->{$SEPARATE_CPM_STRATEGY_ID}{'fields'}}
          if $strategies->{$SEPARATE_CPM_STRATEGY_ID};
    }
    #тематики
    if ($self->DOES('Application::Model::Role::Block::Has::PICategories')) {
        push @fields, 'picategories';
    }
    #бренды
    if ($self->DOES('Application::Model::Role::Has::Brands')) {
        push @fields, 'brands';
    }
    #гео
    if ($self->DOES('Application::Model::Role::Has::Geo')) {
        push @fields, 'data_geo';
    }

    my $data              = {hash_transform($block, \@fields)};
    my $actions           = delete $data->{actions};
    my $is_custom_bk_data = delete $data->{is_custom_bk_data};

    if ($is_custom_bk_data) {
        my $bk_data = from_json($data->{bk_data});
        $self->convert_godmode($bk_data, $next_currency, $currency_rate);
        $patch->{bk_data} = to_json($bk_data, pretty => TRUE);
    } else {
        delete $data->{$_} foreach (qw(bk_data is_custom_bk_data));
    }

    foreach my $key (grep {$_ ne 'bk_data'} keys %{$data}) {
        if (defined $data->{$key} && ref $data->{$key} eq 'ARRAY' && @{$data->{$key}}) {
            my $has_changes = FALSE;
            foreach (@{$data->{$key}}) {
                next unless defined $_->{'cpm'} && $_->{'cpm'} > 0 && $_->{'cpm'} < $MAX_CPM;
                $_->{'cpm'} = $self->_fix_cpm_value(sprintf('%.3f', $_->{'cpm'} / $currency_rate)) + 0;
                $has_changes = TRUE;
            }
            next unless $has_changes;
            if ($key eq 'data_geo') {
                $patch->{geo} = to_json($data->{$key}, canonical => TRUE);
            } else {
                $patch->{$key} = $data->{$key};
            }

        }

        if (defined $data->{$key} && ref $data->{$key} eq '' && $data->{$key} > 0 && $data->{$key} < $MAX_CPM) {
            $patch->{$key} = $self->_fix_cpm_value(sprintf('%.3f', $data->{$key} / $currency_rate)) + 0;
        }
    }

    return unless keys %$patch;
    # Если блок можно редактировать - меняем его через do_action,
    # в противном случае (заархивирован, протектед) - меняем через
    # запрос в БД
    my $can_edit = $actions->{'edit'};

    if ($can_edit) {
        my $patch_for_edit = $is_custom_bk_data ? {hash_transform($patch, [qw(bk_data)])} : $patch;
        $self->do_action($block, 'edit', %$patch_for_edit);
    }

    if (!$can_edit || $is_custom_bk_data) {
        delete $patch->{bk_data} unless $is_custom_bk_data;
        my $table        = $self->partner_db_table();
        my $picategories = delete $patch->{picategories};
        my $brands       = delete $patch->{brands};
        $table->edit($block, $patch) if %$patch;
        $self->brands->replace({block_id => $block->{id}, page_id => $block->{$self->get_page_id_field_name()}},
            $brands, 'edit')
          if defined $brands && @$brands;
        $self->picategories->replace({block_id => $block->{id}, page_id => $block->{$self->get_page_id_field_name()}},
            $picategories, 'edit')
          if defined $picategories && @$picategories;
    }
}

sub convert_godmode {
    my ($self, $bk_data, $next_currency, $currency_rate) = @_;

    $bk_data->{'CPMCurrency'} = $next_currency;
    foreach my $info (@{$bk_data->{'DSPInfo'} // []}) {
        next unless defined $info->{'CPM'} && $info->{'CPM'} > 0 && $info->{'CPM'} < $MAX_CPM * 1000;
        $info->{'CPM'} = floor($info->{'CPM'} / $currency_rate);
    }
    foreach my $key (qw(Geo Brand AdType Article)) {
        $self->convert_hash_value($bk_data->{$key} // {}, [qw(value)], $currency_rate);
    }
    $self->convert_hash_value($bk_data->{'PICategoryIAB'}, $RTB_PRODUCT_TYPES, $currency_rate);

}

sub convert_hash_value {
    my ($self, $hash, $keys_to_convert, $currency_rate) = @_;
    foreach my $key (keys %$hash) {
        foreach my $subkey (keys %{$hash->{$key}}) {
            next unless in_array($subkey, $keys_to_convert);
            $hash->{$key}->{$subkey} = floor($hash->{$key}->{$subkey} / $currency_rate);
        }
    }
}

sub get_currency_by_page_id {
    my ($self, $page_id) = @_;
    my $owner =
      $self->app->{$self->get_campaign_model_name()}->get_all(fields => ['owner'], filter => {page_id => $page_id})
      ->[0];
    return $owner->{owner}->{current_currency} if $owner;
}

sub make_fields_defaults {
    my ($self, $opts, $need_fields) = @_;

    my %result = ();

    if ($need_fields->{'current_currency'}) {
        $result{'current_currency'} = $self->get_currency_by_page_id($opts->{attributes}->{page_id});
    }

    return \%result;
}

sub get_fields_depends {
    return {
        #если поменялось поле из ключа, то
        #нужно перезапросить поля из значения
        depends => {page_id => [qw(current_currency)],},
        #для поля из ключа обязятельно нужно передать поля из значения
        required => {current_currency => [qw(page_id)],},
    };
}

sub _fix_cpm_value {
    my ($self, $cpm_value) = @_;
    $cpm_value = $MAX_CPM if $cpm_value > $MAX_CPM;
    $cpm_value = 0.001    if 0 == $cpm_value;
    return $cpm_value;
}

TRUE;
