package Application::Model::Role::Block::Has::CloseButtonDelay;

use qbit;

use Application::Model::Role;
use PiConstants qw($BLOCK_TYPE_INTERSTITIAL);

my $FIELD_NAME                       = 'close_button_delay';
my $DEFAULT_CLOSE_BUTTON_DELAY_VALUE = 2;
my $MIN_CLOSE_BUTTON_DELAY_VALUE     = 0;
my $MAX_CLOSE_BUTTON_DELAY_VALUE     = 15;

sub get_structure_rights_to_register {
    my ($self) = @_;

    return [{rights => {map {$self->get_description_right($_ . $FIELD_NAME)} qw(edit_field__ view_field__),}}];
}

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        $FIELD_NAME => {
            from_opts  => 'from_hash',
            label      => d_gettext('Close button delay'),
            type       => 'number',
            need_check => {
                optional => TRUE,
                type     => 'int_un',
                min      => $MIN_CLOSE_BUTTON_DELAY_VALUE,
                max      => $MAX_CLOSE_BUTTON_DELAY_VALUE,
                msg      => d_gettext(
                    "Close button delay value must be from '%d' to '%d'", $MIN_CLOSE_BUTTON_DELAY_VALUE,
                    $MAX_CLOSE_BUTTON_DELAY_VALUE
                ),
            },
            api => 1,
        },
    };
}

sub fix_template {
    my ($self, $qv) = @_;
    if ($qv->data->{'block_type'} ne $BLOCK_TYPE_INTERSTITIAL) {
        $qv->template->{'fields'}{$FIELD_NAME} = {eq => undef, optional => TRUE};
    }
}

sub get_fields_depends {
    return {
        #если поменялось поле из ключа, то
        #нужно перезапросить поля из значения
        depends => {block_type => [$FIELD_NAME],},
        #для поля из ключа обязятельно нужно передать поля из значения
        required => {$FIELD_NAME => [qw(block_type)],},
    };
}

sub get_bk_block_data {
    my ($self, $block, $data) = @_;

    if ($block->{'block_type'} eq $BLOCK_TYPE_INTERSTITIAL) {
        $data->{'CustomBlockData'}{'close-button-delay'} = $block->{$FIELD_NAME};
    }

    return $data;
}

sub get_editable_fields_depends {[qw(block_type)]}

sub collect_editable_fields {
    my ($self, $data, $fields) = @_;

    if ($data->{'block_type'} eq $BLOCK_TYPE_INTERSTITIAL) {
        $fields->{$FIELD_NAME} = TRUE if $self->check_short_rights("edit_field__" . $FIELD_NAME);
    } else {
        delete $fields->{$FIELD_NAME};
    }
    return $fields;
}

sub get_available_fields_depends {[qw(block_type)]}

sub get_available_fields {
    my ($self, $obj, $fields) = @_;

    my $accessor = $self->accessor();

    if ($obj->{'block_type'} eq $BLOCK_TYPE_INTERSTITIAL) {
        $self->app->delete_field_by_rights(
            $fields,
            {
                $accessor . '_view_field__%s' => [$FIELD_NAME],
                $accessor . '_edit_field__%s' => [$FIELD_NAME],
            }
        );
    } else {
        delete $fields->{$FIELD_NAME};
    }

    return $fields;
}

sub get_add_fields {
    my ($self, $fields, $data) = @_;
    my %obj = 'HASH' eq ref $data ? %$data : ();
    #TODO: фронт должен передавать хэш а не строку
    if ($self->accessor eq 'internal_mobile_app_rtb' && ref($data) eq '') {
        %obj = (block_type => $data);
    }

    if ($obj{'block_type'} && $obj{'block_type'} eq $BLOCK_TYPE_INTERSTITIAL) {
        $fields->{$FIELD_NAME} = TRUE if $self->check_short_rights("edit_field__" . $FIELD_NAME);
    }
    return $fields;
}

sub hook_set_initialize_settings {
    my ($self, $opts) = @_;

    if ($opts->{'block_type'} eq $BLOCK_TYPE_INTERSTITIAL) {
        $opts->{$FIELD_NAME} //= $DEFAULT_CLOSE_BUTTON_DELAY_VALUE;
    }
}

sub get_need_update_in_bk_fields {
    return {$FIELD_NAME => TRUE};
}

sub make_fields_defaults {
    my ($self, $opts, $need_fields) = @_;

    my %result = ();

    if (exists($opts->{'block_type'}) && $opts->{'block_type'} && $opts->{'block_type'} eq $BLOCK_TYPE_INTERSTITIAL) {
        $result{$FIELD_NAME} = $DEFAULT_CLOSE_BUTTON_DELAY_VALUE;
    }

    return \%result;
}

1;
