package Application::Model::Role::Block::Has::ContentWidgetCommon;

use qbit;

use Application::Model::Role;

sub get_structure_model_fields {
    my ($self) = @_;

    my $max_grid_size = $self->get_widget_grid_size();
    return {
        css => {
            from_opts  => 'from_hash',
            label      => d_gettext('Style'),
            type       => 'string',
            need_check => {type => 'scalar',},
            api        => 1,
        },
        grid_rows => {
            from_opts  => 'from_hash',
            label      => d_gettext('Number of rows'),
            type       => 'number',
            need_check => {
                type => 'int_un',
                min  => 1,
                msg  => d_gettext("Rows value must be from '%d' to '%d'", 1, $max_grid_size),
                max  => $max_grid_size,
            },
            api => 1,
        },
        grid_columns => {
            from_opts  => 'from_hash',
            label      => d_gettext('Number of columns'),
            type       => 'number',
            need_check => {
                type => 'int_un',
                min  => 1,
                msg  => d_gettext("Columns value must be from '%d' to '%d'", 1, $max_grid_size),
                max  => $max_grid_size,
            },
            api => 1,
        },
        template => {
            from_opts  => 'from_hash',
            label      => d_gettext('Template'),
            type       => 'string',
            need_check => {type => 'scalar',},
            api        => 1,
        },
    };
}

sub get_add_fields {
    my ($self, $fields) = @_;

    return $self->_widget_common_add_all_fields($fields);
}

sub collect_editable_fields {
    my ($self, $obj, $fields) = @_;

    return $self->_widget_common_add_all_fields($fields);
}

sub get_need_update_in_bk_fields {
    my ($self) = @_;

    return $self->_widget_common_add_all_fields();
}

sub get_bk_block_data {
    my ($self, $block, $data) = @_;

    my $h = $data->{'CustomBlockData'}{WidgetInfo} //= {};
    $h->{'CSS'} = $block->{css};

    my $template = $block->{template};
    foreach (qw(grid_columns grid_rows)) {
        $template =~ s/\$\{$_\}/$block->{$_}/g;
    }

    if ($template =~ /<ya-units-slider/ && $block->{grid_rows} == 1) {
        $h->{'IsSlider'} = TRUE;
    }

    $h->{'Template'} = $template;
    $h->{'Height'}   = 0 + $block->{grid_rows};
    $h->{'Width'}    = 0 + $block->{grid_columns};

    return $data;
}

sub _widget_common_add_all_fields {
    my ($self, $fields) = @_;

    $fields //= {};

    $fields->{$_} = TRUE foreach (
        qw(
        css
        grid_columns
        grid_rows
        template
        )
    );

    return $fields;
}

TRUE;
