package Application::Model::Role::Block::Has::FieldsModeration;

use qbit;

use Application::Model::Role;

consume qw(Application::Model::Role::Has::FieldsModeration);

sub get_bk_block_data {
    my ($self, $block, $data) = @_;

    my $test_mode = $self->check_multistate_flag($block->{multistate}, 'testing');
    my $fields_moderated = $self->get_fields_moderated();

    if (exists $fields_moderated->{caption}) {
        $data->{'BlockCaption'} = $block->{$test_mode ? 'caption' : 'caption_approved'};
    }

    if (exists $fields_moderated->{address}) {
        $data->{'CustomBlockData'}{dooh}{address} = $block->{$test_mode ? 'address' : 'address_approved'};
        $data->{'CustomBlockData'}{dooh}{gps}     = $block->{$test_mode ? 'gps'     : 'gps_approved'};
    } elsif (exists $self->get_page_model->get_fields_moderated->{address}) {
        $data->{'CustomBlockData'}{dooh}{address} = $block->{page}{$test_mode ? 'address' : 'address_approved'};
        $data->{'CustomBlockData'}{dooh}{gps}     = $block->{page}{$test_mode ? 'gps'     : 'gps_approved'};
    }

    return $data;
}

TRUE;
