package Application::Model::Role::Block::Has::InitUniqueId;

use qbit;

use Application::Model::Role;

use Utils::UniqueID qw( make_unique_id );

requires qw(accessor is_block_table_with_multiple_models get_page_id_field_name);

sub hook_set_initialize_settings {
    my ($self, $opts) = @_;

    if ($self->is_block_table_with_multiple_models()) {
        $opts->{'model'} = $self->accessor();

        my $page_id_field_name = $self->get_page_id_field_name();

        $opts->{'unique_id'} =
          make_unique_id($self->accessor(), $opts->{'page_id'} // $opts->{$page_id_field_name}, $opts->{'id'});
    }
}

TRUE;
