package Application::Model::Role::Block::Has::IsExternalMediation;
use qbit;

use Application::Model::Role;

my $FIELD_NAME    = 'is_external_mediation';
my $DEFAULT_VALUE = FALSE;
my $EDIT_RIGHT    = 'edit_field__' . $FIELD_NAME;

sub get_structure_rights_to_register {
    my ($self) = @_;

    return [{rights => {map {$self->get_description_right($_)} ($EDIT_RIGHT)}}];
}

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        $FIELD_NAME => {
            from_opts => 'from_hash',
            type      => 'boolean',
            get       => sub {
                $_[1]->{$FIELD_NAME} = ($_[1]->{$FIELD_NAME} // $DEFAULT_VALUE) ? 1 : 0;
                return $_[1]->{$FIELD_NAME};
            },
            need_check => {
                optional => TRUE,
                type     => 'boolean',
            },
            api => 1
        },
    };
}

sub collect_editable_fields {
    my ($self, $data, $fields) = @_;

    $fields->{$FIELD_NAME} = TRUE if $self->check_short_rights($EDIT_RIGHT);
    return $fields;
}

sub get_available_fields {
    my ($self, $obj, $fields) = @_;

    $fields->{$FIELD_NAME} = TRUE;
    return $fields;
}

sub get_add_fields {
    my ($self, $fields) = @_;

    $fields->{$FIELD_NAME} = TRUE;
    return $fields;
}

sub hook_set_initialize_settings {
    my ($self, $opts) = @_;

    $opts->{$FIELD_NAME} //= $DEFAULT_VALUE ? 1 : 0;
}

1;
