package Application::Model::Role::Block::Has::IsHidden;
use qbit;

use Application::Model::Role;

sub get_structure_rights_to_register {
    my ($self) = @_;

    return [
        {
            rights => {
                map {$self->get_description_right($_)}
                  qw(
                  edit_field__is_hidden
                  view_field__is_hidden
                  ),
            }
        }
    ];
}

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        is_hidden => {
            from_opts  => 'from_hash',
            type       => 'boolean',
            need_check => {
                optional => TRUE,
                type     => 'boolean',
            },
            api => 1
        },
    };
}

sub get_bk_block_data {
    my ($self, $block, $data) = @_;

    $data->{'CustomBlockData'}{'IsHidden'} = $block->{'is_hidden'} ? 1 : 0;

    return $data;
}

sub collect_editable_fields {
    my ($self, $data, $fields) = @_;

    $fields->{is_hidden} = TRUE if $self->check_short_rights('edit_field__is_hidden');
    return $fields;
}

sub get_available_fields {
    my ($self, $obj, $fields) = @_;

    my $accessor = $self->accessor();

    $self->app->delete_field_by_rights(
        $fields,
        {
            $accessor . '_view_field__%s' => [qw(is_hidden)],
            $accessor . '_edit_field__%s' => [qw(is_hidden)],
        }
    );

    return $fields;
}

sub get_add_fields {
    my ($self, $fields) = @_;

    $fields->{is_hidden} = TRUE if $self->check_short_rights('edit_field__is_hidden');
    return $fields;
}

sub hook_set_initialize_settings {
    my ($self, $opts) = @_;

    $opts->{'is_hidden'} //= 0;
}

sub get_need_update_in_bk_fields {
    return {is_hidden => TRUE};
}

1;
