package Application::Model::Role::Block::Has::IsMobileMediation;

use qbit;

use Application::Model::Role;

consume qw(Application::Model::Role::Has::IsMobileMediation);

sub collect_editable_fields {
    my ($self, $obj, $fields) = @_;

    if ($self->check_short_rights('edit_field__is_mobile_mediation')) {
        $fields->{'is_mobile_mediation'} = TRUE;
    } else {
        delete($fields->{'is_mobile_mediation'});
    }

    return $fields;
}

sub hook_set_initialize_settings {
    my ($self, $opts) = @_;

    if ($self->hook_stash->inited() && $self->hook_stash->mode('duplicate')) {
        $opts->{is_mobile_mediation} = 0;
    }
}

TRUE;
