package Application::Model::Role::Block::Has::MediaBlock;

use qbit;

use Application::Model::Role;

use Exception::Validation::BadArguments;
use Exception::Validator::Fields;

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        media_block => {
            db         => TRUE,
            label      => d_gettext('Media block format'),
            type       => 'string',
            need_check => {
                len_max => 12,     # as in database
                check   => sub {
                    my ($qv, $media_block) = @_;
                    my %media_blocks;
                    try {
                        %media_blocks = map {$_->{'id'} => $_} @{$qv->app->get_types_media_blocks($qv->data)};
                    }
                    catch Exception::Validation::BadArguments with {
                        my ($exception) = @_;

                        throw Exception::Validator::Fields $exception;
                    };

                    throw Exception::Validator::Fields gettext('Invalid media block type')
                      if !defined($media_block) || !$media_blocks{$media_block};
                },
            },
            api => 1,
        },
    };
}

TRUE;
