package Application::Model::Role::Block::Has::MediaBlockCalculate;

use qbit;

use Application::Model::Role;

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        media_block => {
            depends_on => [qw(dsp_blocks)],
            get        => sub {
                my ($fields, $row) = @_;

                my $dsp_blocks = $row->{'dsp_blocks'};

                return undef unless @$dsp_blocks;

                my @media_sizes =
                  sort {$b->{'square'} <=> $a->{'square'} || $b->{'height'} <=> $a->{'height'}}
                  map {_calculate_square($_)} @$dsp_blocks;

                return $media_sizes[0]->{'format'};
            },
            label => d_gettext('Media block format'),
        },
    };
}

sub _calculate_square {
    my ($format) = @_;

    my $media_format = {
        format => $format,
        square => 0,
        height => 0,
    };

    if ($format =~ /^(\d+)(%?)x(\d+)$/) {
        my ($width, $percent, $height) = ($1, $2, $3);

        if ($percent) {
            $media_format->{'square'} = $height;
            $media_format->{'height'} = $height;
        } else {
            $media_format->{'square'} = $width * $height;
            $media_format->{'height'} = $height;
        }
    }

    return $media_format;
}

TRUE;
