package Application::Model::Role::Block::Has::MetricaReports;

use qbit;

use Application::Model::Role;

our $METRICA_REPORTS = [
    {
        link_template => 'https://metrika.yandex.ru/stat/yan_recommendations?id=',
        name_template => d_gettext('Report on engagement')
    },
    {
        link_template => 'https://metrika.yandex.ru/stat/yan_recommendation_sources?id=',
        name_template => d_gettext('Report on placement pages')
    },
    {
        link_template => 'https://metrika.yandex.ru/stat/yan_recommendation_popular?id=',
        name_template => d_gettext('Report on materials')
    }
];

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        metrica_reports => {
            depends_on => ['page_id', 'pages.metrica_counters'],
            label      => d_gettext('Metrica widget reports'),
            get        => sub {
                my ($self, $obj) = @_;

                my %result;
                foreach my $counter (@{$self->{'pages'}{$obj->{'page_id'}}{'metrica_counters'}}) {
                    $result{$counter} =
                      [map {{name => $_->{name_template}->(), link => $_->{link_template} . $counter}}
                          @$METRICA_REPORTS];
                }
                return \%result;
            },
            type => 'complex',
            api  => 1,
        },
    };
}

TRUE;
