package Application::Model::Role::Block::Has::MobileAppMode;

use qbit;

use Application::Model::Role;

sub get_structure_rights_to_register {
    my ($self) = @_;

    return [
        {
            rights => {
                map {$self->get_description_right($_)}
                  qw(
                  view_field__mobile_app_mode
                  edit_field__mobile_app_mode
                  ),
            }
        }
    ];
}

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        mobile_app_mode => {
            from_opts  => 'from_hash',
            type       => 'number',
            api        => 1,
            need_check => {
                type => 'int_un',
                in   => [0, 1, 2],
            },
        },
    };
}

sub get_available_fields {
    my ($self, $obj, $fields) = @_;

    if ($self->check_short_rights('view_field__mobile_app_mode')) {
        $fields->{mobile_app_mode} = 1;
    } else {
        delete $fields->{mobile_app_mode};
    }

    return $fields;
}

sub get_add_fields {
    my ($self, $fields) = @_;

    if ($self->check_short_rights('edit_field__mobile_app_mode')) {
        $fields->{mobile_app_mode} = 1;
    }

    return $fields;
}

sub collect_editable_fields {
    my ($self, $obj, $fields) = @_;

    if ($self->check_short_rights('edit_field__mobile_app_mode')) {
        $fields->{mobile_app_mode} = 1;
    } else {
        delete $fields->{mobile_app_mode};
    }

    return $fields;
}

sub get_need_update_in_bk_fields {
    return {mobile_app_mode => 1,};
}

sub get_bk_block_data {
    my ($self, $block, $data) = @_;

    my %option_to_status = (
        'no-mobile-app'   => ($block->{mobile_app_mode} == 1 ? 'Enable' : 'Disable'),
        'only-mobile-app' => ($block->{mobile_app_mode} == 2 ? 'Enable' : 'Disable'),
    );

    push @{$data->{'PageImpOptions'}{$option_to_status{$_}}}, $_ for sort keys(%option_to_status);

    return $data;
}

sub hook_fields_processing_before_validation {
    my ($self, $opts) = @_;

    if ($self->hook_stash->mode('add')) {
        $opts->{mobile_app_mode} //= 0;
    }
}

TRUE;
