package Application::Model::Role::Block::Has::MoneyMap;

use qbit;
use Application::Model::Role;

use Exception::IncorrectParams;
use Exception::MoneyMap;

consume qw(Application::Model::Role::Has::MoneyMap);

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        moneymap => {
            api        => 1,
            db         => FALSE,
            label      => d_gettext('MoneyMap'),
            type       => 'complex',
            depends_on => [qw(page_id id)],
            get        => sub {
                my ($fields, $obj) = @_;
                return $fields->{'__MONEYMAP__'}->{$obj->{page_id}}{$obj->{id}} // {};
            },
            lazy => 1,
        },
    };
}

sub pre_process_fields {
    my ($self, $fields, $result) = @_;

    if ($fields->need('moneymap')) {
        my $block_ids = $fields->stash->{'block_ids'} //=
          array_uniq(map {join '-', $_->{'page_id'}, $_->{'id'}} @$result);

        $fields->{'__MONEYMAP__'} = $fields->model->app->api_moneymap->get_blocks_by_ids($block_ids, TRUE);
    }
}

sub hook_preparing_fields_to_save {
    my ($self, $opts) = @_;

    if (exists $opts->{moneymap} && $self->check_short_rights('edit_field__moneymap')) {
        my $login = $self->get_option('cur_user', {})->{login};
        try {
            if ($self->hook_stash->mode('add')) {
                my $page_id = $opts->{page_id} // $opts->{$self->get_page_id_field_name()};
                $self->app->api_moneymap->add_block(
                    login         => $login,
                    page_id       => $page_id,
                    block_id      => $opts->{id},
                    opts_moneymap => $opts->{moneymap},
                );
            } elsif ($self->hook_stash->mode('edit')) {
                my $pk = $self->hook_stash->get('id');
                $self->app->api_moneymap->edit_block(
                    login         => $login,
                    page_id       => $pk->{page_id},
                    block_id      => $pk->{id},
                    opts_moneymap => $opts->{moneymap},
                );
            }
        }
        catch Exception::MoneyMap with {
            my ($e) = @_;
            throw Exception::IncorrectParams $e;
        };
    }
    return TRUE;
}

sub get_default_owner_login {
    my ($self) = @_;

    return $self->get_page_model()->get_default_owner_login();
}

sub get_traffic_type {
    my ($self) = @_;

    return $self->get_page_model()->get_traffic_type();
}

TRUE;
