package Application::Model::Role::Block::Has::NaturalWidget;

use qbit;

use Application::Model::Role;

use PiConstants qw(
  $NATURAL_BLOCK_GRID_SIZE
  $NATURAL_BLOCK_TRANSPORT_TYPE
  );

consume qw(
  Application::Model::Role::Block::Has::ContentWidgetCommon
  );

sub get_widget_grid_size {
    return $NATURAL_BLOCK_GRID_SIZE;
}

sub get_bk_block_data {
    my ($self, $block, $data) = @_;

    $data->{DirectLimit} = $block->{grid_rows} * $block->{grid_columns};
    my $h = $data->{'CustomBlockData'}{WidgetInfo} //= {};
    $h->{Type} = $NATURAL_BLOCK_TRANSPORT_TYPE;

    return $data;
}

TRUE;
