package Application::Model::Role::Block::Has::OnlyPortalTrustedBanners;

use qbit;

use Application::Model::Role;

sub get_structure_rights_to_register {
    my ($self) = @_;

    return [
        {
            rights => {
                map {$self->get_description_right($_)}
                  qw(
                  edit_field__only_portal_trusted_banners
                  view_field__only_portal_trusted_banners
                  ),
            }
        }
    ];
}

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        only_portal_trusted_banners => {
            from_opts  => 'from_hash',
            type       => 'boolean',
            need_check => {type => 'boolean', optional => TRUE,},
            api        => 1,
        },
    };
}

sub get_bk_block_data {
    my ($self, $block, $bk_data) = @_;

    $bk_data->{'CustomBlockData'}{'only-portal-trusted-banners'} = $block->{'only_portal_trusted_banners'} ? 1 : 0;

    return $bk_data;
}

sub collect_editable_fields {
    my ($self, $data, $fields) = @_;

    $fields->{only_portal_trusted_banners} = TRUE
      if $self->check_short_rights('edit_field__only_portal_trusted_banners');
    return $fields;
}

sub get_available_fields {
    my ($self, $obj, $fields) = @_;

    my $accessor = $self->accessor();

    $self->app->delete_field_by_rights(
        $fields,
        {
            $accessor . '_view_field__%s' => [qw(only_portal_trusted_banners)],
            $accessor . '_edit_field__%s' => [qw(only_portal_trusted_banners)],
        }
    );

    return $fields;
}

sub get_add_fields {
    my ($self, $fields) = @_;

    $fields->{only_portal_trusted_banners} = TRUE
      if $self->check_short_rights('edit_field__only_portal_trusted_banners');
    return $fields;
}

sub get_need_update_in_bk_fields {
    return {only_portal_trusted_banners => 1};
}

1;
