package Application::Model::Role::Block::Has::PartnerReadOnly;

use qbit;

use Application::Model::Role;

consume qw(Application::Model::Role::Has::PartnerReadOnly);

my $FIELD_NAME    = 'partner_read_only';
my $EDIT_RIGHT    = 'edit_field__' . $FIELD_NAME;
my $DEFAULT_VALUE = FALSE;

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        $FIELD_NAME => {
            api        => 1,
            depends_on => ['page_id', "pages.$FIELD_NAME"],
            get        => sub {
                $_[0]->{pages}{$_[1]->{page_id}}{$FIELD_NAME};
            },
            label => d_gettext('Closed from editing'),
            type  => 'boolean',
        },
    };
}

sub _partner_read_only_can_action {
    my ($self, $obj) = @_;

    return FALSE
      if (!$self->get_page_model->check_short_rights($EDIT_RIGHT)
        && $self->_get_object_fields($obj, [$FIELD_NAME])->{$FIELD_NAME});

    return TRUE;
}

1;
