package Application::Model::Role::Block::Has::ShowSlider;

use qbit;

use Application::Model::Role;

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        show_slider => {
            from_opts  => 'from_hash',
            type       => 'boolean',
            need_check => {
                optional => TRUE,
                type     => 'boolean',
            },
            api => 1
        },
    };
}

sub collect_editable_fields {
    my ($self, $obj, $fields) = @_;

    if ($obj->{block_type} eq 'native') {
        $fields->{show_slider} = TRUE;
    } else {
        delete($fields->{'show_slider'});
    }

    return $fields;
}

sub get_available_fields {
    my ($self, $obj, $fields) = @_;

    if ($obj->{block_type} eq 'native') {
        $fields->{'show_slider'} = TRUE;
    } else {
        delete($fields->{'show_slider'});
    }

    return $fields;
}

sub get_add_fields {
    my ($self, $fields, $data) = @_;

    my %obj = 'HASH' eq ref $data ? %$data : ();

    my $block_type = $obj{block_type} // '';
    #TODO: фронт должен передавать хэш а не строку
    if ($self->accessor eq 'internal_mobile_app_rtb' && ref($data) eq '') {
        $block_type = $data;
    }

    if (defined($block_type) && $block_type eq 'native') {
        $fields->{'show_slider'} = TRUE;
    }

    return $fields;
}

sub get_editable_fields_depends {
    return [qw(block_type show_slider)];
}

sub get_available_fields_depends {
    return [qw(block_type show_slider)];
}

sub hook_set_initialize_settings {
    my ($self, $opts) = @_;

    $opts->{'show_slider'} //= 0;
}

sub get_need_update_in_bk_fields {
    return {show_slider => TRUE};
}

sub hook_fields_processing_before_validation {
    my ($self, $opts) = @_;

    my $settings = $self->hook_stash->get('settings');

    # В старой форме мобильных RTB для нативных блоков приходит limit=>1
    $opts->{limit} = undef
      if ( $settings->{block_type} eq 'native'
        && !$settings->{show_slider}
        && defined($opts->{limit})
        && $opts->{limit} == 1);

    return if !$self->hook_stash->mode('edit') || !exists($opts->{show_slider});

    my $current = $self->hook_stash->get('current');
    $opts->{limit} = undef
      if $current->{show_slider} && exists($opts->{show_slider}) && !$opts->{show_slider} && !exists($opts->{limit});
    $opts->{limit} //= 1
      if !$current->{show_slider} && exists($opts->{show_slider}) && $opts->{show_slider} && !exists($opts->{limit});
}

1;
