package Application::Model::Role::Block::Has::UniqueId;

use qbit;

use Application::Model::Role;

consume qw(Application::Model::Role::Block::Has::InitUniqueId);

use Exception::Validator::Fields;
use Utils::UniqueID qw( make_unique_id );

requires qw(get_unique_id_prefix);

sub get_structure_rights_to_register {
    my ($self) = @_;

    return [
        {
            rights => {
                map {$self->get_description_right($_)}
                  qw(
                  view_field__unique_id
                  ),
            }
        }
    ];
}

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        unique_id => {
            db         => TRUE,
            type       => 'number',
            need_check => {
                type     => 'int_un',
                optional => TRUE,
                check    => sub {
                    my ($qv, $unique_id) = @_;

                    if ($unique_id !=
                        make_unique_id($qv->app->get_unique_id_prefix(), $qv->data->{page_id}, $qv->data->{id}))
                    {
                        throw Exception::Validator::Fields("Incorrect unique_id: $unique_id");
                    }

                    return TRUE;
                },
            },
        },
    };
}

sub get_structure_model_filter {
    my ($self) = @_;

    return {fields => {unique_id => {type => 'number'},}};

}

sub get_available_fields {
    my ($self, $obj, $fields) = @_;

    $self->app->delete_field_by_rights($fields, {$self->get_right('view_field__unique_id') => 'unique_id',});
    return $fields;
}

TRUE;
