package Application::Model::Role::Has::AllowedTurbo;

use qbit;

use Application::Model::Role;

use PiConstants qw(@YAN_MIRRORS_LIST);

sub get_structure_rights_to_register {
    my ($self) = @_;

    return [
        {
            rights => {
                map {$self->get_description_right($_)}
                  qw(
                  edit_field__allowed_turbo
                  view_field__allowed_turbo
                  )
            }
        }
    ];
}

sub get_structure_model_fields {
    return {allowed_turbo =>
          {db => TRUE, type => 'boolean', need_check => {type => 'boolean'}, api => 1, adjust_type => 'str',}
    };
}

sub get_available_fields {
    my ($self, $obj, $fields) = @_;

    unless ($self->check_short_rights('view_field__allowed_turbo')) {
        delete($fields->{'allowed_turbo'});
    }

    $fields->{'allowed_turbo'} = TRUE if $obj->{'allowed_turbo'};

    return $fields;
}

sub get_add_fields {
    my ($self, $fields) = @_;

    if ($self->check_short_rights('edit_field__allowed_turbo')) {
        $fields->{'allowed_turbo'} = TRUE;
    } else {
        delete($fields->{'allowed_turbo'});
    }

    return $fields;
}

sub collect_editable_fields {
    my ($self, $obj, $fields) = @_;

    if ($self->check_short_rights('edit_field__allowed_turbo')) {
        $fields->{'allowed_turbo'} = 1;
    } else {
        delete $fields->{'allowed_turbo'};
    }

    return $fields;
}

sub get_need_update_in_bk_fields {
    return {allowed_turbo => 1};
}

sub get_bk_data {
    my ($self, $page, $data) = @_;

    #PI-9826 allowed_turbo
    if ($page->{'allowed_turbo'}) {
        push(@{$data->{'mirrors'}}, @YAN_MIRRORS_LIST);
    }

    return %$data;
}

sub get_available_fields_depends {['allowed_turbo']}

TRUE;
