package Application::Model::Role::Has::AvailableFields;

use qbit;

use Application::Model::Role;

use Utils::JSON qw(fix_type_for_complex);

requires qw(get_available_fields get_available_fields_depends);

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        available_fields => {
            forced_depends_on => $self->get_available_fields_depends(),
            label             => d_gettext('Available fields'),
            get               => sub {
                return $_[0]->model->get_available_fields($_[1]);
            },
            type        => 'complex',
            fix_type    => \&fix_type_for_complex,
            api         => 1,
            adjust_type => 'hash_int',
        },
    };
}

TRUE;
