package Application::Model::Role::Has::Brands;

use qbit;

use Application::Model::Role;

use Partner::BlockPreset::Specification::Brands;

use PiConstants qw(
  $BLOCKED_CPM_VALUE
  );

sub get_structure_model_accessors {
    return {
        brands         => 'Application::Model::Product::Brands',
        tns_dict_brand => 'Application::Model::TNSDict::Brand',
    };
}

sub get_structure_rights_to_register {
    my ($self) = @_;

    return [
        {
            rights => {
                map {$self->get_description_right($_)}
                  qw(
                  edit_field__brands
                  ),
            }
        }
    ];
}

sub get_structure_model_fields {
    my ($self) = @_;

    my $brands_specification = Partner::BlockPreset::Specification::Brands->new();
    my $validation_template  = $brands_specification->get_validation_template();

    return {
        brands => {
            depends_on => [qw(page_id id)],
            label      => d_gettext('Brands'),
            type       => 'array',
            sub_type   => 'brands',
            need_check => $validation_template->{'brands'},
            get        => sub {
                return defined($_[1]->{'page_id'})
                  && defined($_[1]->{'id'}) ? $_[0]->{'__BRANDS__'}{$_[1]->{'page_id'}}{$_[1]->{'id'}} : [];
            },
            api         => 1,
            adjust_type => 'array_hash_str',
        },
        has_brands_settings => {
            depends_on => ['brands'],
            get        => sub {
                return defined($_[1]->{'brands'}) && $_[1]->{'brands'} ne '[]';
            },
            type => 'boolean',
            api  => 1,
        },
    };
}

sub pre_process_fields {
    my ($self, $fields, $result) = @_;

    if ($fields->need('brands')) {
        my $page_ids = $fields->stash->{'page_ids'} //= array_uniq(map {$_->{'page_id'}} @$result);

        my $brands = $self->brands->get_all(
            fields => [qw(bid page_id block_id blocked cpm)],
            filter => {page_id => $page_ids},
        );

        $fields->{'__BRANDS__'} //= {};
        foreach my $brand (@$brands) {
            my $brands_stash = $fields->{'__BRANDS__'}->{$brand->{'page_id'}}->{$brand->{'block_id'}} //= [];

            my $new_brand = {bid => $brand->{'bid'}, blocked => $brand->{'blocked'}};
            $new_brand->{'cpm'} = $brand->{'cpm'} + 0 if $brand->{'cpm'};

            push @$brands_stash, $new_brand;
        }
    }
}

sub get_available_fields {
    my ($self, $obj, $fields) = @_;

    $fields->{$_} = TRUE foreach (qw(brands has_brands_settings));

    return $fields;
}

sub get_add_fields {
    my ($self, $fields) = @_;

    $fields->{'brands'} = TRUE;

    return $fields;
}

sub hook_save_fields_from_related_models {
    my ($self, $opts) = @_;

    if ($self->hook_stash->check('fields_from_related_models')
        and my $brands = $self->hook_stash->get('fields_from_related_models')->{'brands'})
    {
        my $page_id_field_name = $self->get_page_id_field_name();
        my %filter;
        @filter{qw(page_id block_id)} = @{$self->hook_stash->get('id')}{$page_id_field_name, 'id'};

        $self->brands->replace(\%filter, $brands, ($self->hook_stash->mode('add') ? 'add' : 'edit'));
    }
}

sub get_need_update_in_bk_fields {
    return {brands => TRUE};
}

sub collect_editable_fields {
    my ($self, $obj, $fields) = @_;

    $fields->{'brands'} = TRUE;

    return $fields;
}

sub get_bk_block_data {
    my ($self, $block, $bk_data) = @_;

    $bk_data->{'Brand'} =
      {map {$_->{'bid'} => {currency => 'RUB', value => $_->{'blocked'} ? $BLOCKED_CPM_VALUE : $_->{'cpm'} * 1000}}
          @{$block->{'brands'} || []}};

    return $bk_data;
}

TRUE;
