package Application::Model::Role::Has::Categories;

use qbit;

use Application::Model::Role;

consume qw(
  Application::Model::Role::Has::Articles
  Application::Model::Role::Block::Has::PICategories
  );

sub hook_fields_processing_before_validation {
    my ($self, $opts) = @_;

    if (defined $opts->{articles} && defined $opts->{picategories}) {
        throw Exception::Validation::BadArguments gettext("only articles or picategories value enabled at same time");
    }
    if (defined($opts->{picategories})) {
        $opts->{articles} = to_json($self->picategories_dict->map_articles_from_picategories($opts->{picategories}));
    } elsif (defined($opts->{articles})) {
        $opts->{picategories} = $self->picategories_dict->map_picategories_from_articles(from_json($opts->{articles}));
    }
}

TRUE;
