package Application::Model::Role::Has::CommonShowVideo;

use qbit;

use Application::Model::Role;

consume qw(Application::Model::Role::Has::DSPSWithoutMode);

use Exception::Validator::Fields;

requires qw(
  get_video_dsp_list
  get_video_dsp_list_depends
  get_video_dsp_turn_on_block_filter
  role_show_video_get_fields_depends
  );

sub get_structure_rights_to_register {
    my ($self) = @_;

    return [
        {
            rights => {
                map {$self->get_description_right($_)}
                  qw(
                  edit_field__show_video
                  view_field__show_video
                  ),
            }
        }
    ];
}

sub get_structure_model_fields {
    my ($self) = @_;

    # Для *context_on_site_rtb нельзя выставить show_video=1 без выданой
    # владельцу пейджа фичи inpage_via_rtb
    return {
        show_video => {
            db          => TRUE,
            type        => 'boolean',
            need_check  => {type => 'boolean',},
            api         => 1,
            adjust_type => 'str',
        },
    };
}

sub get_structure_model_filter {
    my ($self) = @_;

    return {fields => {show_video => {type => 'boolean'},}};
}

sub get_available_fields {
    my ($self, $obj, $fields) = @_;

    if (($self->check_short_rights('view_field__show_video') || $obj->{show_video})
        && $self->is_show_video_applicable($obj)->{applicable})
    {
        $fields->{'show_video'} = TRUE;
    } else {
        delete($fields->{'show_video'});
    }

    return $fields;
}

sub get_editable_fields_depends {
    my ($self) = @_;

    return $self->role_show_video_get_fields_depends();
}

sub get_available_fields_depends {
    my ($self) = @_;

    return $self->role_show_video_get_fields_depends();
}

sub set_show_video_add_fields {
    my ($self, $obj, $fields) = @_;

    my $info = $self->is_show_video_applicable($obj);

    if ($info->{applicable}) {
        if ($self->check_short_rights('edit_field__show_video')) {
            $fields->{'show_video'} = TRUE;
        } else {
            delete $fields->{'show_video'};
        }
    } else {
        delete $fields->{'show_video'};
    }

    return;
}

sub get_need_update_in_bk_fields {
    return {show_video => TRUE};
}

sub collect_editable_fields {
    my ($self, $obj, $fields) = @_;

    if ($self->check_short_rights('edit_field__show_video') && $self->is_show_video_applicable($obj)->{applicable}) {
        $fields->{'show_video'} = TRUE;
    } else {
        delete $fields->{'show_video'};
    }

    return $fields;
}

sub get_show_video_dsp_rule {
    my ($self) = @_;

    my @video_dsp_list_depends = $self->get_video_dsp_list_depends();

    return Partner::DSP::Rule->new(
        default_dsps => Partner::DSP::Rule::Part->new(
            depends_on => {block => [qw(show_video), @video_dsp_list_depends],},
            sub        => sub {
                my ($block) = @_;

                my $info = $self->is_show_video_applicable($block);
                $block->{show_video} = $info->{default_value} unless $info->{applicable};
                if ($block->{show_video}) {
                    my @list = $self->get_video_dsp_list($block);
                    if (@list) {
                        return extend => ['id', 'IN', \@list];
                    } else {
                        return limit => Partner::DSP::Rule::Filter->identity();
                    }
                } else {
                    return extend => Partner::DSP::Rule::Filter->zero();
                }
            },
        ),
        turn_on_dsp => Partner::DSP::Rule::Part->new(
            depends_on => {dsp => [qw(id)],},
            sub        => sub {
                my ($dsp) = @_;
                if (my $filter = $self->get_video_dsp_turn_on_block_filter($dsp)) {
                    return limit => $filter;
                } else {
                    return limit => Partner::DSP::Rule::Filter->identity();
                }
            },
        ),
        dsps_field_validation => Partner::DSP::Rule::Part->new(
            sub => sub {
                my ($block, $dsps) = @_;

                return unless $block->{show_video};

                my @video_dsps = $self->get_video_dsp_list_for_validation($block);

                return unless @video_dsps;

                throw Exception::Validator::Fields gettext('Choose DSP for Video ad')
                  if @{arrays_intersection($dsps, \@video_dsps)} == 0;
            },
        ),
        dsps_field_edit => Partner::DSP::Rule::Part->new(
            depends_on => {block => [qw(show_video)]},
            sub        => sub {
                my ($old_block, $opts) = @_;

                my $dsps = $opts->{'dsps'} // $old_block->{'dsps'};
                my %available_dsps = map {$_->{id} => TRUE} @{$self->get_available_dsps({%$old_block, %$opts})};
                my @video_dsps     = $self->get_video_dsp_list($old_block);
                my %video_dsps     = map {$_ => TRUE} @video_dsps;

                if ($old_block->{show_video} && !$opts->{show_video}) {
                    $opts->{'dsps'} = [grep {$available_dsps{$_} && !$video_dsps{$_}} @$dsps];
                } elsif (
                    !$old_block->{show_video} && $opts->{show_video} && !(
                        grep {
                            exists $video_dsps{$_}
                        } @$dsps
                    )
                  )
                {
                    $opts->{'dsps'} = [@$dsps, grep {$available_dsps{$_}} @video_dsps];
                }
            },
        )
    );
}

sub get_special_show_video_dsp_rule {
    my ($self) = @_;

    my @video_dsp_list_depends = $self->get_video_dsp_list_depends();

    return Partner::DSP::Rule->new(
        available_dsps => Partner::DSP::Rule::Part->new(
            depends_on => {block => [qw(show_video), @video_dsp_list_depends],},
            sub        => sub {
                my ($block) = @_;

                my $info = $self->is_show_video_applicable($block);
                $block->{show_video} = $info->{default_value} unless $info->{applicable};
                if ($block->{show_video}) {
                    my @list = $self->get_video_dsp_list($block);
                    if (@list) {
                        return extend => ['id', 'IN', \@list];
                    } else {
                        return limit => Partner::DSP::Rule::Filter->identity();
                    }
                } else {
                    return extend => Partner::DSP::Rule::Filter->zero();
                }
            },
        ),
    );
}

sub get_dsp_type_depends {
    return +{};
}

sub hook_fields_processing_before_validation {
    my ($self, $opts) = @_;

    if ($self->hook_stash->mode('add')) {
        my $info = $self->is_show_video_applicable($opts);

        $opts->{'show_video'} //= $info->{'default_value'} // 0;
    }
}

sub make_fields_defaults {
    my ($self, $opts) = @_;

    my %need_fields = map {$_ => TRUE} @{$opts->{fields}};

    my $result = {};

    if ($need_fields{'show_video'}) {
        my $video_applicable = $self->is_show_video_applicable($opts->{attributes});

        $result->{'default_values'} //= {};
        $result->{'default_values'}{'show_video'} = $video_applicable->{default_value} // 0;

        $result->{'show_video'} = [];
        if ($video_applicable && $video_applicable->{applicable}) {
            push @{$result->{'show_video'}}, (0, 1);
        } else {
            push @{$result->{'show_video'}}, $result->{'default_values'}{'show_video'};
        }
    }

    return $result;
}

TRUE;
