package Application::Model::Role::Has::Context;

use qbit;

use Application::Model::Role;

requires qw(accessor_ya_categories);

consume qw(
  Application::Model::Role::Has::UnmoderatedRtbAuction
  Application::Model::Role::Has::AllowedTurbo
  Application::Model::Role::Has::Filters
  );

use PiConstants qw($SITE_VERSIONS_TURBO);

sub get_structure_rights_to_register {
    my ($self) = @_;

    return [
        {
            rights => {
                map {$self->get_description_right($_)}
                  qw(
                  view_field__ya_categories
                  view_field__fast_context
                  edit_field__fast_context
                  view_field__only_picture
                  edit_field__only_picture
                  view_field__performance_tgo_disable
                  edit_field__performance_tgo_disable
                  ),
            }
        }
    ];
}

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        behavioral_targeting => {
            db          => TRUE,
            type        => 'boolean',
            api         => 1,
            need_check  => {type => 'boolean', optional => TRUE},
            adjust_type => 'str',
        },
        fast_context => {
            db          => TRUE,
            type        => 'boolean',
            api         => 1,
            need_check  => {type => 'boolean', optional => TRUE},
            adjust_type => 'str',
        },
        only_picture => {
            db          => TRUE,
            type        => 'boolean',
            api         => 1,
            need_check  => {type => 'boolean', optional => TRUE},
            adjust_type => 'str',
        },
        view_images => {
            db          => TRUE,
            type        => 'boolean',
            api         => 1,
            need_check  => {type => 'boolean', optional => TRUE},
            adjust_type => 'str',
        },
        product_type => {
            get => sub {
                return 'context';
            },
            type => 'string',
        },
        ya_categories => {
            depends_on   => ['page_id'],
            check_rights => $self->get_right('view_field__ya_categories'),
            get          => sub {
                my ($self, $obj) = @_;

                # TODO удалить следующую строчку в одном из следующих ПР, например по PI-15793
                return [] unless $obj->{'page_id'};

                return ($self->{'__YA_CATEGORIES__'}{$obj->{'page_id'}} // []);
            },
            type     => 'array',
            sub_type => $self->accessor_ya_categories,
            api      => 1,
        },
        performance_tgo_disable => {
            label      => d_gettext('Performance TGO Disable'),
            db         => 1,
            type       => 'boolean',
            api        => 1,
            need_check => {
                type     => 'boolean',
                optional => TRUE,
            },
            adjust_type => 'str',
        },
    };
}

sub get_structure_model_filter {
    return {fields => {}};
}

sub pre_process_fields {
    my ($self, $fields, $result) = @_;

    my $page_ids = array_uniq(map {$_->{'page_id'} // ()} @$result);

    if ($fields->need('ya_categories')) {
        $fields->{'__YA_CATEGORIES__'} = {};

        my $accessor = $self->accessor_ya_categories;
        foreach (@{$self->$accessor->get_categories_for_view($page_ids)}) {
            my $campaign_id = delete($_->{'campaign_id'});

            $fields->{'__YA_CATEGORIES__'}{$campaign_id} //= [];
            push(@{$fields->{'__YA_CATEGORIES__'}{$campaign_id}}, $_);
        }
    }
}

sub get_add_fields {
    my ($self, $fields) = @_;

    for my $f (qw(behavioral_targeting view_images)) {
        $fields->{$f} = TRUE;
    }

    for my $f (qw(only_picture fast_context performance_tgo_disable)) {
        if ($self->check_short_rights('edit_field__' . $f)) {
            $fields->{$f} = TRUE;
        } else {
            delete($fields->{$f});
        }
    }

    return $fields;
}

sub delete_turbo_and_amp_blocks {
    my ($self, $obj, $opts, $old_obj) = @_;

    my @types = ();

    if (exists($opts->{'allowed_amp'}) && $opts->{'allowed_amp'} == 0 && $old_obj->{'allowed_amp'} == 1) {
        push(@types, 'amp');
    }

    if (exists($opts->{'allowed_turbo'}) && $opts->{'allowed_turbo'} == 0 && $old_obj->{'allowed_turbo'} == 1) {
        push(@types, keys %$SITE_VERSIONS_TURBO);
    }

    if (@types) {
        my $accessor = $self->accessor;

        my $block_model;
        my @fields = qw(campaign_id id multistate);

        if ($accessor eq 'context_on_site_campaign') {
            $block_model = 'context_on_site_rtb';
            push(@fields, 'adfox_block');
        } elsif ($accessor eq 'internal_context_on_site_campaign') {
            $block_model = 'internal_context_on_site_rtb';
        } else {
            throw Exception gettext('Unexpected accessor: %s', $accessor);
        }

        my $blocks = $self->$block_model->get_all(
            fields => \@fields,
            filter => [
                'AND',
                [
                    ['campaign_id',  '=', $old_obj->{'page_id'}],
                    ['site_version', '=', \@types],
                    ['multistate',   '=', 'not deleted']
                ]
            ]
        );

        foreach my $block (@$blocks) {
            $self->$block_model->do_action($block, $block->{'adfox_block'} ? 'delete_from_adfox' : 'delete');
        }
    }
}

sub hook_processing_after_update {
    my ($self, $opts) = @_;

    $self->delete_turbo_and_amp_blocks($self->hook_stash->get('id'), $opts, $self->hook_stash->get('current'));
}

TRUE;
