package Application::Model::Role::Has::ContextShowVideo;

use qbit;

use Application::Model::Role;

consume qw(Application::Model::Role::Has::CommonShowVideo);

use PiConstants qw(
  $DEFAULT_VIDEO_SKIN
  $DSP_DIRECT_ID
  $DSP_VIDEO_TYPE_ID
  $VIDEO_PLATFORM_HTML5
  $VIDEO_PLATFORMS
  );

sub is_show_video_applicable {
    my ($self, $block) = @_;

    my $hs = $self->hook_stash;
    my $current;
    my $is_add_mode;
    if ($hs->inited()) {
        $current     = $hs->get('current');
        $is_add_mode = $hs->mode('add');
    }

    if (($block->{site_version} // '') eq 'amp') {
        return {
            applicable    => 0,
            default_value => 0,
        };
    } elsif (
        ($block->{site_version} // '') eq 'turbo_desktop'
        && ((defined $current ? !$current->{show_video} : !$block->{show_video})
            || $is_add_mode)
      )
    {
        return {
            applicable    => 0,
            default_value => 0,
        };
    } else {
        return {applicable => 1};
    }
}

sub get_video_dsp_list_for_validation {
    my ($self, $block) = @_;

    return ($DSP_DIRECT_ID, $self->get_video_dsp_list($block));
}

# Блочный метод get_bk_data
sub get_bk_data {
    my ($self, $page_id, $bk_data) = @_;

    # rtb_video в API конвертируется в RtbVideo
    #
    # Так как ключ надо пробросить на верхний уровень,
    # а список блоков здесь уже не доступен,
    # но при этом доступна информация по блокам, которая будет отправлена в БК,
    # то чтобы не делать повторных запросов на список всех блоков,
    # использовано то, что в bk_data на нужных блоках проставляется тип DSP video.
    # См. sub get_bk_block_data
    $bk_data->{rtb_video} //= _get_default_rtb_video()
      if grep {($_->{DSPType} // 0) & 2} values %{$bk_data->{$self->get_bk_block_data_key()} // {}};

    return %$bk_data;
}

sub get_bk_block_data {
    my ($self, $block, $bk_data) = @_;

    my $info = $self->is_show_video_applicable($block);
    $block->{show_video} = $info->{default_value} unless $info->{applicable};

    if ($block->{show_video}) {
        $bk_data->{DSPType} |= 2;    # 2**1 video
    }

    return $bk_data;
}

sub get_dsp_type {
    my ($self, $block) = @_;

    my @result;
    my $info = $self->is_show_video_applicable($block);
    $block->{show_video} = $info->{default_value} unless $info->{applicable};
    if ($block->{show_video}) {
        push @result, $DSP_VIDEO_TYPE_ID;
    }

    return \@result;
}

sub get_dsp_type_depends {
    return +{block => [qw(show_video)]};
}

sub _get_default_rtb_video {
    return {
        BufferEmptyLimit  => 5,
        BufferFullTimeout => 5000,
        Categories        => {0 => {Name => gettext('Domain of video resourse'), Archive => 0}},
        Contents          => {},
        Platform          => $VIDEO_PLATFORMS->{$VIDEO_PLATFORM_HTML5}{'type'},
        Skin              => $DEFAULT_VIDEO_SKIN,
        SkinTimeout       => 5000,
        SkipDelay         => 5,
        SkipTimeLeftShow  => 1,
        TimeLeftShow      => 1,
        Title             => gettext('Video resources'),
        VASTTimeout       => 5000,
        VPAIDEnabled      => 1,
        VPAIDTimeout      => 5000,
        VideoTimeout      => 5000,
        WrapperMaxCount   => 3,
        WrapperTimeout    => 5000,
    };
}

TRUE;
