package Application::Model::Role::Has::CreateDate;

use qbit;

use Application::Model::Role;

sub get_structure_model_fields {
    my ($self) = @_;

    return {create_date => {db => TRUE, label => d_gettext('Create date'), type => 'string', api => 1,},};
}

sub get_structure_model_filter {
    my ($self) = @_;

    return {fields => {create_date => {type => 'date', label => d_gettext('Create date')},},};
}

sub hook_set_initialize_settings {
    my ($self, $opts) = @_;

    $opts->{'create_date'} = curdate(oformat => 'db_time');
}

TRUE;
