package Application::Model::Role::Has::CreatorId;

use qbit;

use Application::Model::Role;

sub get_structure_model_fields {
    my ($self) = @_;

    return {creator_id => {db => TRUE, label => d_gettext('Creator id'), type => 'int_un', adjust_type => 'str',}};
}

sub get_structure_model_filter {
    my ($self) = @_;

    return {fields => {creator_id => {type => 'number', label => d_gettext('Creator id')},},};
}

sub hook_set_initialize_settings {
    my ($self, $opts) = @_;

    $opts->{'creator_id'} = $self->get_option(cur_user => {})->{'id'};
}

TRUE;
