package Application::Model::Role::Has::CustomBkData;

use qbit;

use Application::Model::Role;

sub get_structure_rights_to_register {
    my ($self) = @_;

    return [
        {
            rights => {
                map {$self->get_description_right($_)}
                  qw(
                  edit_field__bk_data
                  view_field__bk_data
                  ),
            }
        }
    ];
}

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        bk_data => {
            db         => TRUE,
            label      => d_gettext('BK data'),
            type       => 'string',
            need_check => {type => 'bk_data', optional => TRUE},
            get        => sub {
                return (
                    $_[1]->{'bk_data'}
                    ? to_json(from_json($_[1]->{'bk_data'}), pretty => TRUE,)
                    : $_[1]->{'bk_data'}
                );
            },
            api => 1,
        },
        is_custom_bk_data => {
            db          => TRUE,
            label       => d_gettext('Custom BK data enabled'),
            type        => 'boolean',
            need_check  => {type => 'boolean'},
            api         => 1,
            adjust_type => 'str',
        },
    };
}

sub get_structure_model_filter {
    my ($self) = @_;

    return {fields => {is_custom_bk_data => {type => 'boolean', label => d_gettext('Custom BK data enabled')},},};
}

sub get_available_fields {
    my ($self, $obj, $fields) = @_;

    if ($self->check_short_rights('view_field__bk_data')) {
        $fields->{'bk_data'} = 1;
    } else {
        delete($fields->{'bk_data'});
    }

    return $fields;
}

sub can_action_edit {
    my ($self, $obj) = @_;

    my $object = $self->_get_object_fields($obj, [qw(is_custom_bk_data)]);

    if ($object->{'is_custom_bk_data'} && !$self->check_short_rights('edit_field__bk_data')) {
        return FALSE;
    }

    return TRUE;
}

sub get_need_update_in_bk_fields {
    {
        bk_data           => 1,
        is_custom_bk_data => 1,
    };
}

sub get_editable_fields_depends {
    [
        qw(
          is_custom_bk_data
          )
    ];
}

sub get_actions_depends {
    [
        qw(
          is_custom_bk_data
          )
    ];
}

sub hook_set_initialize_settings {
    my ($self, $obj, %opts) = @_;

    my $hook_stash = $self->hook_stash();
    if ($hook_stash->inited() && $hook_stash->mode('duplicate')) {
        if ($obj->{bk_data}) {
            my $RtbDesign = from_json($obj->{'bk_data'})->{'RtbDesign'};
            if ($RtbDesign) {
                my $id = {
                    id                              => $obj->{'id'},
                    $self->get_page_id_field_name() => $obj->{$self->get_page_id_field_name()},
                };

                my $new_public_id = $self->public_id($id);

                # Пока возможно 2 случая. Первый когда в RtbDesign приходит сразу хэш.
                # Второй - Когда приходит список хэшей
                if (!ref($RtbDesign)) {
                    my $old_public_id = from_json('{' . $RtbDesign . '}')->{'blockId'};

                    $obj->{'bk_data'} =~ s/(\\"blockId\\"\s*:\s*\\")$old_public_id\\"/$1$new_public_id\\"/g
                      if defined $old_public_id;
                } elsif (ref($RtbDesign) eq 'HASH') {
                    foreach my $key (keys %{$RtbDesign}) {
                        my $old_public_id = $RtbDesign->{$key}->{'design'}->{'blockId'};

                        $obj->{'bk_data'} =~ s/("blockId"\s*:\s*")$old_public_id"/$1$new_public_id"/g
                          if defined $old_public_id;
                    }
                }
            }

            if ($opts{modify_fields} && $opts{modify_fields}{vmap_id}) {
                if ($self->check_feature_on_page($obj->{page_id}, 'instream_vmap')) {
                    my $bk_data = from_json($obj->{bk_data});
                    $bk_data->{VmapID} = $opts{modify_fields}{vmap_id};
                    $obj->{bk_data} = to_json($bk_data, pretty => TRUE);
                }
            }
        }
    }
}

1;
