package Application::Model::Role::Has::DSPS;

use qbit;

use Application::Model::Role;

consume qw(
  Application::Model::Role::Has::DSPSWithoutMode
  );

use Exception::Validator::Fields;

use PiConstants qw($MIN_CPM_STRATEGY_ID $SEPARATE_CPM_STRATEGY_ID @DSP_MODE);

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        dsp_mode => {
            api        => 1,
            depends_on => ['dsps'],
            from_opts  => 'from_hash',
            need_check => {
                optional => TRUE,
                in       => \@DSP_MODE,
                check    => sub {
                    my ($qv, $dsp_mode_value) = @_;

                    if ('ARRAY' eq ref $qv->{'data'}{'dsps'}) {
                        if ($dsp_mode_value ne 'auto') {
                            unless (@{$qv->{'data'}{'dsps'}}) {
                                throw Exception::Validation::BadArguments gettext(
                                    'Empty dsp list with whitelist/blacklist dsp_mode');
                            }
                        }
                    }
                  }
            },
            type => 'string',
        }
    };
}

sub get_available_fields {
    my ($self, $obj, $fields) = @_;

    if ($self->check_short_rights('view_field__dsps')) {
        $fields->{$_} = TRUE for qw(dsp_mode);
    } else {
        delete($fields->{$_}) for qw(dsp_mode);
    }

    return $fields;
}

sub get_add_fields {
    my ($self, $fields) = @_;

    if ($self->check_short_rights('edit_field__dsps')) {
        $fields->{$_} = TRUE for qw(dsp_mode);
    }

    return $fields;
}

sub hook_fields_processing_before_validation {
    my ($self, $opts) = @_;

    if ($self->hook_stash->mode('add')) {
        $opts->{dsp_mode} //= 'force';
    }
}

sub get_need_update_in_bk_fields {
    return {dsp_mode => TRUE};
}

sub get_bk_block_data {
    my ($self, $block, $bk_data) = @_;

    my $mincpm = $block->{'mincpm'} || 0;
    $mincpm *= 1000 if grep {$_ eq $block->{strategy}} ($MIN_CPM_STRATEGY_ID, $SEPARATE_CPM_STRATEGY_ID);

    $bk_data->{'MinCPM'} = $mincpm + 0;
    $bk_data->{'DSPSettings'} //= {
        'DSP'         => [],
        'DSPBindMode' => '',
        'Unmoderated' => []
    };
    $bk_data->{'DSPSettings'}{DSPBindMode} = $block->{dsp_mode} // 'force';

    for (@{$block->{'dsps'}}) {
        my $dsp_id = 'HASH' eq ref $_ ? $_->{dsp_id} : $_;
        push @{$bk_data->{'DSPSettings'}{'DSP'}}, $dsp_id;
    }

    return $bk_data;
}

sub collect_editable_fields {
    my ($self, $obj, $fields) = @_;

    if ($self->check_short_rights('edit_field__dsps')) {
        $fields->{$_} = TRUE for qw(dsp_mode);
        if (exists $obj->{dsp_mode} && $obj->{dsp_mode} && 'auto' eq $obj->{dsp_mode}) {
            delete $fields->{dsps};
        }
    }

    return $fields;
}

sub get_fields_defaults {
    my ($self, $opts) = @_;

    # see https://st.yandex-team.ru/PI-29527 for more details
    my %excluded_modes = map {$_ => TRUE} qw(auto);

    my %need_fields = map {$_ => TRUE} @{$opts->{fields}};

    my $result = {};

    if ($need_fields{'dsp_mode'}) {
        $result->{dsp_mode} = [sort grep {!$excluded_modes{$_}} @DSP_MODE];
    }

    return $result;
}

TRUE;
