package Application::Model::Role::Has::DSPS::GraysiteRule;

use qbit;

use Application::Model::Role;

use PiConstants qw(
  $DSP_AWAPS_ID
  );

consume qw(Application::Model::Role::Has::DSPS);

sub get_graysite_dsp_rule {
    return Partner::DSP::Rule->new(
        default_dsps => Partner::DSP::Rule::Part->new(
            depends_on => {page => [qw(is_graysite)],},
            sub        => sub {
                my ($block, $page) = @_;
                if ($page->{is_graysite}) {
                    return limit => [id => '<>' => $DSP_AWAPS_ID];
                } else {
                    return limit => Partner::DSP::Rule::Filter->identity();
                }
            },
        ),
        turn_on_dsp => Partner::DSP::Rule::Part->new(
            depends_on => {dsp => [qw(id)],},
            sub        => sub {
                my ($dsp) = @_;
                if ($dsp->{id} == $DSP_AWAPS_ID) {
                    return limit => ['is_graysite_block', '=', 0];
                } else {
                    return limit => Partner::DSP::Rule::Filter->identity();
                }
            },
        ),
    );
}

TRUE;
