package Application::Model::Role::Has::DSPS::MobileAdaptiveBannerRule;

use qbit;

use Application::Model::Role;

use PiConstants qw(
  $DSP_DIRECT_ID
  );

consume qw(Application::Model::Role::Has::DSPS);

sub get_mobile_adaptive_banner_dsp_rule {
    return Partner::DSP::Rule->new(
        available_dsps => Partner::DSP::Rule::Part->new(
            # TODO: вернуть, когда фронт в мобильных перейдет с розетты на рестапи
            #depends_on => {block => [qw(block_type)],},
            sub => sub {
                my ($block) = @_;
                if (exists $block->{block_type} && $block->{block_type} eq 'adaptive_banner') {
                    return extend => [id => '=' => $DSP_DIRECT_ID];
                } else {
                    return limit => Partner::DSP::Rule::Filter->identity();
                }
            },
        ),
        default_dsps => Partner::DSP::Rule::Part->new(
            depends_on => {block => [qw(block_type)],},
            sub        => sub {
                my ($block) = @_;
                if ($block->{block_type} eq 'adaptive_banner') {
                    return extend => [id => '=' => $DSP_DIRECT_ID];
                } else {
                    return limit => Partner::DSP::Rule::Filter->identity();
                }
            },
        ),
        turn_on_dsp => Partner::DSP::Rule::Part->new(
            depends_on => {block => [qw(id)],},
            sub        => sub {
                my ($dsp) = @_;

                if ($dsp->{id} == $DSP_DIRECT_ID) {
                    return limit => Partner::DSP::Rule::Filter->identity();
                } else {
                    return limit => [block_type => '<>' => 'adaptive_banner'];
                }
            },
        ),
        dsps_field_validation => Partner::DSP::Rule::Part->new(
            sub => sub {
                my ($block, $dsps) = @_;

                throw Exception::Validator::Fields gettext('Adaptive banner block can work only with Direct DSP')
                  if ($block->{block_type} eq 'adaptive_banner') && !(@$dsps == 1 && $dsps->[0] == $DSP_DIRECT_ID);
            },
        ),
    );
}

TRUE;
