package Application::Model::Role::Has::DSPS::MobileNativeRule;

use qbit;

use Application::Model::Role;

use PiConstants qw(
  $DSP_DIRECT_ID
  $DSP_CRITEO_NATIVE
  $DSP_NATIVE_FORMAT_ID
  $DSP_BANNER_FORMAT_ID
  );

requires qw(get_dsp_working_on_all_pages_multistate_name);

consume qw(Application::Model::Role::Has::DSPS);

sub get_mobile_native_dsp_rule {
    my ($self) = @_;

    return Partner::DSP::Rule->new(
        # TODO: limit available_dsps for native block. Needs frontend support
        default_dsps => Partner::DSP::Rule::Part->new(
            depends_on => {block => [qw(block_type)]},
            sub        => sub {
                my ($block) = @_;
                if ($block->{block_type} eq 'native') {
                    return extend => [
                        AND => [
                            [formats    => '=' => $DSP_NATIVE_FORMAT_ID],
                            [multistate => '=' => $self->get_dsp_working_on_all_pages_multistate_name()],
                        ]
                    ];
                } else {
                    return limit => Partner::DSP::Rule::Filter->identity();
                }
            },
        ),
        available_dsps => Partner::DSP::Rule::Part->new(
            depends_on => {block => [qw(block_type)]},
            sub        => sub {
                my ($block) = @_;
                if ($block->{block_type} eq 'native') {
                    return extend => [formats => '=' => $DSP_NATIVE_FORMAT_ID];
                } else {
                    return limit => Partner::DSP::Rule::Filter->identity();
                }
            },
        ),
        turn_on_dsp => Partner::DSP::Rule::Part->new(
            depends_on => {dsp => [qw(id formats)]},
            sub        => sub {
                my ($dsp) = @_;
                if ($dsp->{formats} && in_array($DSP_NATIVE_FORMAT_ID, $dsp->{formats})) {
                    return extend => [block_type => '=' => 'native'];
                } else {
                    return extend => Partner::DSP::Rule::Filter->zero();
                }
            },
        ),
    );
}

TRUE;
