package Application::Model::Role::Has::DSPS::MobileRewardedRule;

use qbit;

use Application::Model::Role;

use PiConstants qw(
  $DSP_DIRECT_ID
  $DSP_BANNER_FORMAT_ID
  $DSP_MOBILE_TYPE_ID
  $DSP_VIDEO_FORMAT_ID
  );

requires qw(get_dsp_working_on_all_pages_multistate_name);

consume qw(Application::Model::Role::Has::DSPS);

sub get_mobile_rewarded_dsp_rule {
    my ($self) = @_;

    return Partner::DSP::Rule->new(
        available_dsps => Partner::DSP::Rule::Part->new(
            depends_on => {block => [qw(block_type)]},
            sub        => sub {
                my ($block) = @_;
                if (in_array($block->{block_type}, ['rewarded'])) {
                    return extend => [
                        OR => [
                            [formats => '=' => $DSP_BANNER_FORMAT_ID],
                            # PI-27081
                            [AND => [[types => '=' => $DSP_MOBILE_TYPE_ID], [formats => '=' => $DSP_VIDEO_FORMAT_ID]]]
                        ]
                    ];
                } else {
                    return limit => Partner::DSP::Rule::Filter->identity();
                }
            },
        ),
        default_dsps => Partner::DSP::Rule::Part->new(
            depends_on => {block => [qw(block_type)],},
            sub        => sub {
                my ($block) = @_;
                if ($block->{block_type} eq 'rewarded') {
                    return extend => [
                        OR => [
                            [id => '=' => $DSP_DIRECT_ID],
                            # PI-27081
                            [
                                AND => [
                                    [types      => '=' => $DSP_MOBILE_TYPE_ID],
                                    [formats    => '=' => $DSP_VIDEO_FORMAT_ID],
                                    [multistate => '=' => $self->get_dsp_working_on_all_pages_multistate_name()]
                                ]
                            ]
                        ]
                    ];
                } else {
                    return limit => Partner::DSP::Rule::Filter->identity();
                }
            },
        ),
        turn_on_dsp => Partner::DSP::Rule::Part->new(
            depends_on => {block => [qw(id types formats)],},
            sub        => sub {
                my ($dsp) = @_;

                my %types   = map {$_ => 1} $dsp->{types};
                my %formats = map {$_ => 1} $dsp->{formats};

                if ($dsp->{id} == $DSP_DIRECT_ID
                    || (exists($types{$DSP_MOBILE_TYPE_ID})) && exists($formats{$DSP_VIDEO_FORMAT_ID}))
                {
                    return extend => [block_type => '=' => 'rewarded'];
                } else {
                    return extend => Partner::DSP::Rule::Filter->zero();
                }
            },
        ),
    );
}

TRUE;
