package Application::Model::Role::Has::DSPS::WithSettings;

use qbit;

use Application::Model::Role;

consume qw(
  Application::Model::Role::Has::DSPS
  );

sub get_dsps_field_definition {
    my ($self) = @_;

    return {
        depends_on => [qw(page_id id), 'block_dsps.dsp_id', 'block_dsps.show_count', 'block_dsps.interval'],
        label      => d_gettext('DSP list'),
        get        => sub {
            [map {+{dsp_id => $_->{'dsp_id'}, show_count => $_->{'show_count'}, interval => $_->{'interval'}}}
                  @{$_[0]->{'block_dsps'}{$_[1]->{'page_id'}, $_[1]->{'id'}} // []}];
        },
        type       => 'array',
        sub_type   => 'block_dsps',
        need_check => {
            optional => TRUE,
            type     => 'array',
            all      => {
                type   => 'hash',
                fields => {
                    dsp_id     => {type => 'int_un'},
                    show_count => {
                        type     => 'int_un',
                        min      => 1,
                        max      => 25,
                        optional => TRUE,
                    },
                    interval => {
                        type     => 'int_un',
                        in       => [1800, 3600, 86400],
                        optional => TRUE,
                    },
                },
                all_set => [['show_count', 'interval']]
            },
            check => sub {
                my ($qv, $dsps) = @_;

                $dsps = [map {$_->{dsp_id}} @$dsps];

                $qv->app->validate_dsp_list($qv->data, $dsps);
            },
        },
        api         => 1,
        adjust_type => 'array_hash_str',
    };
}

sub generate_links_from_dsp_list {
    my ($self, $dsp_list) = @_;

    return [map {{dsp_id => $_, interval => undef, show_count => undef}} @$dsp_list];
}

sub get_bk_block_data {
    my ($self, $block, $bk_data) = @_;

    my $mincpm = $block->{'mincpm'} // 0;
    $mincpm *= 1000;

    $bk_data->{'DSPInfo'} = [
        map {
            {
                DSPID => $_->{'dsp_id'},
                CPM   => $mincpm,
                RF    => {
                    ShowsCount => $_->{'show_count'} // 0,
                    Interval   => $_->{'interval'}   // 0
                },
            }
          } @{$block->{'dsps'}}
    ];

    return $bk_data;
}

TRUE;
