package Application::Model::Role::Has::DSPS::WorkingOnAllPagesRule;

use qbit;

use Application::Model::Role;

requires qw(get_dsp_working_on_all_pages_multistate_name);

consume qw(Application::Model::Role::Has::DSPS);

sub get_working_on_all_pages_dsp_rule {
    my ($self) = @_;

    return Partner::DSP::Rule->new(
        default_dsps => Partner::DSP::Rule::Part->new(
            sub => sub {
                return extend => [multistate => '=' => $self->get_dsp_working_on_all_pages_multistate_name()];
            },
        ),
        turn_on_dsp => Partner::DSP::Rule::Part->new(
            depends_on => {dsp => [qw(multistate)],},
            sub        => sub {
                my ($dsp) = @_;
                if (
                    $self->dsp->check_multistate_flag(
                        $dsp->{multistate}, $self->get_dsp_working_on_all_pages_multistate_name()
                    )
                   )
                {
                    return extend => Partner::DSP::Rule::Filter->zero();
                } else {
                    return extend => Partner::DSP::Rule::Filter->identity();
                }
            },
        ),
    );
}

TRUE;
