package Application::Model::Role::Has::DoohDurationMin;

use qbit;

use Application::Model::Role;

use Exception::Validator::Fields;

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        min_duration => {
            from_opts  => 'from_hash',
            type       => 'number',
            need_check => {
                min   => 3,
                max   => 3600,
                msg   => gettext('"min_duration" must be of a range: 3 - 3600 sec and less than "max_duration"'),
                check => sub {
                    my ($qv, $min_duration) = @_;

                    my $max_duration = $qv->data->{'max_duration'}
                      // throw Exception::Validator::Fields gettext('Field "min_duration" depends on "max_duration"');

                    throw Exception::Validator::Fields gettext('"min_duration" must be less than "max_duration"')
                      if $min_duration > $max_duration;
                  }
            },
            api => 1
        },
    };
}

sub get_available_fields {
    my ($self, $obj, $fields) = @_;

    $fields->{'min_duration'} = TRUE;

    return $fields;
}

sub get_add_fields {
    my ($self, $fields) = @_;

    $fields->{'min_duration'} = TRUE;

    return $fields;
}

sub get_need_update_in_bk_fields {
    return {min_duration => 1,};
}

sub collect_editable_fields {
    my ($self, $obj, $fields) = @_;

    $fields->{'min_duration'} = TRUE;

    return $fields;
}

sub get_bk_block_data {
    my ($self, $block, $bk_data, $article_tree) = @_;

    $bk_data->{'CustomBlockData'}{'dooh'}{'min_duration'} = ($block->{'min_duration'} || 0) + 0;

    return $bk_data;
}

TRUE;
