package Application::Model::Role::Has::DoohDurationSlot;

use qbit;

use Application::Model::Role;

use Exception::Validator::Fields;

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        slot_duration => {
            from_opts  => 'from_hash',
            type       => 'number',
            need_check => {
                min => 3_000,
                max => 86400_000,
                msg => gettext('"slot_duration" must be of a range: 3000 - 86400000 milliseconds'),
            },
            api => 1
        },
    };
}

sub get_available_fields {
    my ($self, $obj, $fields) = @_;

    $fields->{'slot_duration'} = TRUE;

    return $fields;
}

sub get_add_fields {
    my ($self, $fields) = @_;

    $fields->{'slot_duration'} = TRUE;

    return $fields;
}

sub get_need_update_in_bk_fields {
    return {slot_duration => 1,};
}

sub collect_editable_fields {
    my ($self, $obj, $fields) = @_;

    $fields->{'slot_duration'} = TRUE;

    return $fields;
}

sub get_bk_block_data {
    my ($self, $block, $bk_data, $article_tree) = @_;

    $bk_data->{'CustomBlockData'}{'dooh'}{'slot_duration'} = $block->{'slot_duration'} + 0;

    return $bk_data;
}

TRUE;
