package Application::Model::Role::Has::DurationMax;

use qbit;

use Application::Model::Role;

use PiConstants qw(
  $DESIGN_TYPES
  );

my $FIELD_NAME    = 'max_duration';
my $EDIT_RIGHT    = 'edit_field__' . $FIELD_NAME;
my $VIEW_RIGHT    = 'view_field__' . $FIELD_NAME;
my $BK_GROUP      = 'Video';
my $BK_NAME       = 'MaxDuration';
my $DEFAULT_VALUE = 60;

my $DEFAULT_SETTINGS = {
    min      => 0,
    max      => 180,
    optional => TRUE,
};
my $DOOH_SETTINGS = {
    min      => 3,
    max      => 3600,
    optional => FALSE,
};

sub get_structure_rights_to_register {
    my ($self) = @_;

    return [{rights => {map {$self->get_description_right($_)} $EDIT_RIGHT, $VIEW_RIGHT,}}];
}

sub get_structure_model_fields {
    my ($self) = @_;

    my $settings = ((grep {$self->accessor eq $_} qw(indoor_block outdoor_block)) ? $DOOH_SETTINGS : $DEFAULT_SETTINGS);
    return {
        $FIELD_NAME => {
            from_opts  => 'from_hash',
            type       => 'number',
            need_check => {
                msg  => gettext('"max_duration" must be of a range: %d - %d sec', $settings->{min}, $settings->{max}),
                type => 'scalar',
                %$settings,
            },
            api => 1
        },
    };
}

sub get_available_fields {
    my ($self, $obj, $fields) = @_;

    $self->app->delete_field_by_rights(
        $fields,
        {
            $self->get_right($EDIT_RIGHT) => $FIELD_NAME,
            $self->get_right($VIEW_RIGHT) => $FIELD_NAME,
        },
    );

    return $fields;
}

sub get_add_fields {
    my ($self, $fields) = @_;

    $fields->{$FIELD_NAME} = TRUE if $self->check_short_rights($EDIT_RIGHT);

    return $fields;
}

sub collect_editable_fields {
    my ($self, $data, $fields) = @_;

    $fields->{$FIELD_NAME} = TRUE if $self->check_short_rights($EDIT_RIGHT);

    return $fields;
}

sub get_need_update_in_bk_fields {
    return {$FIELD_NAME => TRUE};
}

sub get_bk_block_data {
    my ($self, $block, $bk_data) = @_;

    # Если модель без show_video (DOOH)
    # или тип модели внутренний или внешний context_on_site_rtb, включена галка и есть видео-дизайн
    $bk_data->{$BK_GROUP}{$BK_NAME} = 0 + ($block->{$FIELD_NAME} // $DEFAULT_VALUE)
      if (!$self->DOES('Application::Model::Role::Has::ContextShowVideo')
        || (grep {$self->accessor eq $_} qw(context_on_site_rtb internal_context_on_site_rtb))
        && $block->{show_video}
        && (grep {$_->{type} eq $DESIGN_TYPES->{VIDEO}} @{$block->{design_templates}}));

    return $bk_data;
}

sub hook_set_initialize_settings {
    my ($self, $opts) = @_;

    $opts->{$FIELD_NAME} //= $DEFAULT_VALUE;
}

1;
