package Application::Model::Role::Has::EditRequisites;

use qbit;

use Application::Model::Role;
use Exception::Validation::BadArguments;
use PiConstants qw(
  $PAYMENT_TYPES
  $BRANCHES_MAP
  );

use lib::abs qw(
  ../../../../../api/lib/
  );
use Branches;
use Submit;

sub get_structure_model_accessors {
    my ($self) = @_;

    return {
        api_balance => 'Application::Model::API::Yandex::Balance',
        requisites  => 'Application::Model::Requisites',
    };
}

sub get_branch_id_by_person {
    my ($self, $person, $cooperation_form) = @_;

    return unless $person;

    my $type = $person->{type} // $cooperation_form // '';
    my $branch_id = $BRANCHES_MAP->{$type}->{branch};
    $branch_id = 'russia_ip'
      if (($branch_id // '') eq 'russia_ur' && length($person->{inn} // '') == 12);

    my $country_id;
    if ($person->{country_id}) {
        # конструкция "$person->{country_id} // -1" - не меняет пустую строку на -1
        $country_id = $person->{country_id};
    } else {
        $country_id = -1;
    }

    $branch_id = 'belarus_ph' if ('ag_ph' eq ($branch_id // '') && (149 == $country_id));
    $branch_id = 'ukraine_ph' if ('ag_ph' eq ($branch_id // '') && (187 == $country_id));

    return $branch_id;
}

sub can_action_change_contract {
    my ($self, $user, %opts) = @_;

    return FALSE unless $self->has_feature($user->{id}, 'editable_requisites');

    # Связка с договорами по client_id
    my $tmp_rights = $self->app->add_tmp_rights('users_view_field__client_id');
    $user = $self->_get_object_fields($user, [qw(client_id id multistate)]);
    undef $tmp_rights;

    return FALSE unless $user->{client_id};

    # Получение всех сохранённых в ПИ договоров клиента
    my $data = $self->app->contracts->get_all(
        fields => [qw(contract person_id)],
        filter => [AND => [[client_id => '=' => $user->{client_id}]]]
    );

    foreach (@$data) {
        if ($_->{contract}) {
            $_->{contract} = from_json($_->{contract});
            $self->api_balance->_fix_dates($_->{contract});
        }
    }

    # Надо отфильтровать действующие договора
    # и только те, у которых есть плательщик
    my @result =
      grep {
        $_->{person_id}
          && eval {
            Application::Model::AgreementChecker::_Agreement->new(
                collaterals => [],
                contract    => $_->{contract},
            )->_is_live('today');
          }
      } @$data;

    return scalar(@result) ? TRUE : FALSE;
}

sub on_action_change_contract {
    my ($self, $user, %opts) = @_;

    my $tmp_rights = $self->app->add_tmp_rights('users_view_field__client_id');
    $user = $self->get($user, fields => ['id', 'client_id', 'email', 'cooperation_form']);
    undef $tmp_rights;

    my $active_contract = $self->documents->get_active_contract({client_id => $user->{client_id}, ignore_filter => 1});

    my $branch_id = $self->get_branch_id_by_person($active_contract->{Person}, $user->{cooperation_form});

    my $branches = Branches->new();

    if (exists $opts{representative_position_ur}) {
        my $p = "Field::representative_position_ur";

        $opts{representative_position_ur} = $p->normalize($opts{representative_position_ur});
    }

    %opts = %{
        Submit::_get_converted_fields(
            converter => $branches->get_converter_balance($branch_id),
            fields    => {%opts},
        )
      };

    my $change_pay_to;
    my $changed_bankprops;
    my $changed_address;

    $changed_address = TRUE
      if $opts{registration_address} || $opts{residential_address} || $opts{legal_address} || $opts{mail_address};

    if ($opts{yamoney_wallet}) {
        $changed_bankprops = TRUE;
        if ($active_contract->{Contract}{pay_to} != $PAYMENT_TYPES->{YAMONEY}) {
            throw Exception::Validation::BadArguments(gettext("Incorrect Yandex.Money account number"))
              if $self->get_option('stage', '') eq 'production' && !$self->api_yamoney->is_account_identificated(
                account    => $opts{yamoney_wallet},
                lastname   => $active_contract->{Person}{lname},
                firstname  => $active_contract->{Person}{fname},
                middlename => $active_contract->{Person}{mname},
                passport   => $active_contract->{Person}{passport_s} . ' ' . $active_contract->{Person}{passport_n},
              );

            $opts{$_} = '' foreach (qw(account bik iban swift));
            $change_pay_to = $PAYMENT_TYPES->{YAMONEY};
            $opts{bank_type} = 3;
        }
    }

    if ($opts{account} || $opts{bik} || $opts{iban} || $opts{swift}) {
        $changed_bankprops = TRUE;
        if ($branch_id =~ /russia_ph/) {
            throw Exception::Validation::BadArguments gettext('Account must begin with %s or %s',
                '40817, 42303, 42305, 42306', '42307')
              unless $opts{account} =~ /^(40817|42303|42305|42306|42307)/;
        } elsif ($branch_id =~ /russia_ip/) {
            throw Exception::Validation::BadArguments gettext('Account must begin with %s', '40802')
              unless $opts{account} =~ /^40802/;
        }
        if ($opts{bik}) {
            my $data = $self->api_balance->check_rubank_account(%opts);
            throw Exception::Validation::BadArguments gettext("The account number doesn't correspond with the BIC")
              unless $data->{found};
        }
        if ($opts{swift}) {
            my $data = $self->api_balance->check_bank(%opts);
            throw Exception::Validation::BadArguments gettext("SWIFT code not found")
              unless $data->{found};
        }
        if ($opts{bik}) {
            $opts{$_} = '' foreach (qw(iban swift));
            try {
                my $bank = $self->api_balance->get_bank(Bik => $opts{bik})->[0];
                $opts{ben_bank} = $bank->{bank_name} if $bank->{bank_name};
            };
        } elsif ($opts{swift}) {
            $opts{bik} = '';
            if ($opts{account}) {
                $opts{iban} = '';
            } elsif ($opts{iban}) {
                $opts{account} = '';
            }
            try {
                my $bank = $self->api_balance->get_bank(Swift => $opts{swift})->[0];
                $opts{ben_bank} = $bank->{name} if $bank->{name};
            };
        }
        if ($active_contract->{Contract}{pay_to} != $PAYMENT_TYPES->{BANK}) {
            $change_pay_to = $PAYMENT_TYPES->{BANK};
            $opts{bank_type} = 2;
        }
    }

    $self->api_balance->create_person(
        %opts,
        type         => $active_contract->{Person}{type},
        operator_uid => $user->{id},
        client_id    => $user->{client_id},
        person_id    => $active_contract->{Contract}{person_id},
        ($changed_bankprops ? (invalid_bankprops => 0) : ()),
        ($changed_address   ? (invalid_address   => 0) : ()),
        is_partner => 1,
    );

    if ($change_pay_to) {
        if ($active_contract->{Contract}{is_signed}) {
            $self->api_balance->update_contract_payment_type(
                contract_id  => $active_contract->{Contract}{contract2_id},
                operator_uid => $user->{id},
                pay_to       => $change_pay_to,
                memo         => "создано автоматически",
                num          => 'Ф-б/н.',
            );
        } else {
            $self->api_balance->update_contract(
                contract_id  => $active_contract->{Contract}{contract2_id},
                operator_uid => $user->{id},
                pay_to       => $change_pay_to,
            );
        }
    }

    return {
        public_id => $user->{id},
        %{$self->requisites->fields($user->{id})},
    };
}

TRUE;
