package Application::Model::Role::Has::EditableFields;

use qbit;

use Application::Model::Role;

use Utils::JSON qw(fix_type_for_complex);

requires qw(get_editable_fields_depends get_editable_fields);

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        editable_fields => {
            forced_depends_on => $self->get_editable_fields_depends(),
            get               => sub {
                my ($fields, $row) = @_;
                return $fields->model->get_editable_fields($row);
            },
            type        => 'complex',
            fix_type    => \&fix_type_for_complex,
            api         => 1,
            adjust_type => 'hash_int',
        },
    };
}

TRUE;
