package Application::Model::Role::Has::Filters;

use qbit;

use Application::Model::Role;
use PiConstants qw($BOOKMAKER_FLAG_ID);

sub get_structure_model_accessors {
    return {
        filters          => 'Application::Model::Filters',
        thematic_filters => 'Application::Model::ThematicFilters',
    };
}

sub get_structure_rights_to_register {
    my ($self) = @_;

    return [
        {
            rights => {
                map {$self->get_description_right($_)}
                  qw(
                  view_field__filters
                  edit_field__filters
                  ),
            }
        }
    ];
}

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        filters => {
            label      => d_gettext('Filters list'),
            depends_on => ['page_id', 'filters.filter_id'],
            get        => sub {
                my ($self, $obj) = @_;

                # TODO удалить следующую строчку в одном из следующих ПР, например по PI-15793
                return [] unless $obj->{'page_id'};

                return ($self->{'filters'}{$obj->{'page_id'}} // []);
            },
            type       => 'array',
            sub_type   => 'number',
            need_check => {
                type     => 'array',
                all      => {type => 'int_un'},
                optional => TRUE,
            },
            api         => 1,
            adjust_type => 'array_str',
        },
    };
}

sub related_models {
    return {
        filters => {
            accessor => 'filters',
            filter   => sub {
                return {page_id => array_uniq(map {$_->{'page_id'} // ()} @{$_[1]})};
            },
            key_fields => ['page_id'],
            value_type => 'array_filter_id',
        },
    };
}

sub get_available_fields {
    my ($self, $obj, $fields) = @_;

    if ($self->check_short_rights('view_field__filters')) {
        $fields->{'filters'} = TRUE;
    } else {
        delete($fields->{'filters'});
    }

    return $fields;
}

sub collect_editable_fields {
    my ($self, $obj, $fields) = @_;

    # if ($self->check_short_rights('edit_field__filters')) {
    # TODO изменить следующую строчку в одном из следующих ПР, например по PI-15793
    if (defined($obj->{$self->get_page_id_field_name()}) && $self->check_short_rights('edit_field__filters')) {
        $fields->{'filters'} = TRUE;
    } else {
        delete($fields->{'filters'});
    }

    return $fields;
}

sub hook_set_initialize_settings {
    my ($self, $opts) = @_;

    $opts->{filters} //= [];

    push @{$opts->{filters}}, $BOOKMAKER_FLAG_ID unless (in_array($BOOKMAKER_FLAG_ID, $opts->{filters}));
}

sub hook_save_fields_from_related_models {
    my ($self, $opts) = @_;

    if ($self->hook_stash->check('fields_from_related_models')
        and my $filters = $self->hook_stash->get('fields_from_related_models')->{'filters'})
    {
        $self->filters->replace($self->hook_stash->get('settings')->{$self->get_page_id_field_name},
            $filters, ($self->hook_stash->mode('add') ? 'add' : 'edit'));
    }
}

sub get_need_update_in_bk_fields {
    return {filters => 1,};
}

sub get_bk_data {
    my ($self, $page, $data) = @_;

    my %filter_name =
      map {$_->{'id'} => $_->{'bk_name'}} @{$self->thematic_filters->get_all(fields => [qw(id bk_name)])};

    $data->{'disabled_flags'} = [map {$filter_name{$_}} @{$page->{'filters'}}];

    return %$data;
}

sub get_defaults_thematic_filters {
    my ($self, $need_fields) = @_;

    return $need_fields->{'thematic_filters'}
      ? ('thematic_filters' => $self->thematic_filters->get_all(fields => [qw(id caption)]))
      : ();
}

sub get_fields_defaults {
    my ($self, $opts) = @_;

    my %need_fields = map {$_ => TRUE} @{$opts->{fields}};

    return $need_fields{'thematic_filters'}
      ? {'thematic_filters' => $self->thematic_filters->get_all(fields => [qw(id caption)])}
      : {};
}

TRUE;
