package Application::Model::Role::Has::Geo;

use qbit;

use Application::Model::Role;

use Partner::BlockPreset::Specification::Geo;

use PiConstants qw($BLOCKED_CPM_VALUE $MAX_CPM);

sub get_structure_model_accessors {
    return {geo_base => 'Application::Model::GeoBase'};
}

sub get_structure_rights_to_register {
    my ($self) = @_;

    return [
        {
            rights => {
                map {$self->get_description_right($_)}
                  qw(
                  edit_field__geo
                  ),
            }
        }
    ];
}

sub get_structure_model_fields {
    my ($self) = @_;

    my $geo_specification   = Partner::BlockPreset::Specification::Geo->new();
    my $validation_template = $geo_specification->get_validation_template();

    return {
        geo => {
            db         => TRUE,
            label      => d_gettext('Geo'),
            type       => 'string',
            need_check => $validation_template->{'geo'},
            api        => 1,
        },
        data_geo => {
            label      => d_gettext('Geo data'),
            depends_on => ['geo'],
            get        => sub {
                from_json($_[1]->{'geo'} ? $_[1]->{'geo'} : 'null');
              }
        },
        has_geo_settings => {
            depends_on => ['geo'],
            get        => sub {
                return defined($_[1]->{'geo'}) && $_[1]->{'geo'} ne '[]';
            },
            type => 'boolean',
            api  => 1,
        },
    };
}

sub get_available_fields {
    my ($self, $obj, $fields) = @_;

    $fields->{$_} = TRUE foreach (qw(geo data_geo has_geo_settings));

    return $fields;
}

sub get_add_fields {
    my ($self, $fields) = @_;

    my $accessor = $self->accessor();

    if (in_array($accessor, [qw(internal_context_on_site_rtb internal_mobile_app_rtb)])) {
        $fields->{'geo'} = TRUE if $self->check_short_rights('edit_field__geo');
    } else {
        $fields->{'geo'} = TRUE;
    }

    return $fields;
}

sub collect_editable_fields {
    my ($self, $obj, $fields) = @_;

    my $accessor = $self->accessor();

    if (in_array($accessor, [qw(internal_context_on_site_rtb internal_mobile_app_rtb)])) {
        $fields->{'geo'} = TRUE if $self->check_short_rights('edit_field__geo');
    } else {
        $fields->{'geo'} = TRUE;
    }

    return $fields;
}

sub get_bk_block_data {
    my ($self, $block, $bk_data) = @_;

    $bk_data->{'Geo'} = {
        map {
            $_->{'id'} =>
              {currency => 'RUB', value => ($_->{'cpm'} == $MAX_CPM) ? $BLOCKED_CPM_VALUE : $_->{'cpm'} * 1000}
          } $self->geo_base->get_tree_with_cpm($block->{$self->get_page_id_field_name()}, $block->{'data_geo'})
    };

    return $bk_data;
}

sub get_need_update_in_bk_fields {
    return {geo => TRUE};
}

TRUE;
