package Application::Model::Role::Has::IsMobileMediation;

use qbit;

use Application::Model::Role;

consume qw(Application::Model::Role::Has::IsMobileMediationBase);

sub get_actions_depends {
    [qw(is_mobile_mediation)];
}

sub get_editable_fields_depends {
    [qw(is_mobile_mediation)];
}

sub check_right_for_do_action_mobile_mediation {
    my ($self, $fields) = @_;

    if ($fields->{'is_mobile_mediation'}) {
        return $self->check_rights('can_edit_mobile_mediation');
    } else {
        return TRUE;
    }
}

sub check_action {
    my ($self, $object, $action) = @_;

    my %actions = map {$_ => TRUE} qw(
      reject
      start
      stop
      duplicate
      delete
      restore
      start_testing
      stop_testing
      start_block
      delete_with_page
      restore_with_page
      );

    if (exists $actions{$action}) {
        my $obj = $self->_get_object_fields($object, [qw(is_mobile_mediation)]);

        return $self->check_right_for_do_action_mobile_mediation($obj);
    }

    return TRUE;
}

TRUE;
